<?php $__env->startSection('title', \App\CPU\translate('DB_clean')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/system-setting.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('System_Settings')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inline Menu -->
        <?php echo $__env->make('admin-views.business-settings.system-settings-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inline Menu -->


    <div class="row">
        <div class="col-12 mb-3">
            <div class="alert badge-soft-danger mb-0 mx-sm-2 <?php echo e(Session::get('direction') === 'rtl' ? 'text-right' : 'text-left'); ?>" role="alert">
                <?php echo e(\App\CPU\translate('This_page_contains_sensitive_information.Make_sure_before_changing.')); ?>

            </div>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.business-settings.web-config.clean-db')); ?>" method="post"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-6 col-xl-3">
                                    <div class="form-group form-check <?php echo e(Session::get('direction') === 'rtl' ? 'text-right' : 'text-left'); ?>">
                                        <input type="checkbox" name="tables[]" value="<?php echo e($table); ?>"
                                            class="form-check-input"
                                            id="business_section_<?php echo e($key); ?>">
                                        <label class="form-check-label text-dark"
                                            style="<?php echo e(Session::get('direction') === "rtl" ? 'margin-right: 1.25rem;' : ''); ?>;"
                                            for="business_section_<?php echo e($key); ?>"><?php echo e(\App\CPU\translate(str_replace('_',' ',Str::limit($table, 20)))); ?></label>
                                        <span class="badge-pill badge-secondary mx-2"><?php echo e($rows[$key]); ?></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="d-flex justify-content-end gap-10 flex-wrap mt-3">
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                onclick="<?php echo e(env('APP_MODE')!='demo'?'':'call_demo()'); ?>"
                                class="btn btn--primary"><?php echo e(\App\CPU\translate('Clear')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function () {
        $("#purchase_code_div").click(function () {
            var type = $('#purchase_code').get(0).type;
            if (type === 'password') {
                $('#purchase_code').get(0).type = 'text';
            } else if (type === 'text') {
                $('#purchase_code').get(0).type = 'password';
            }
        });
    })
</script>

<script>
    $("form").on('submit',function(e) {
        e.preventDefault();
        Swal.fire({
            title: '<?php echo e(\App\CPU\translate('Are you sure?')); ?>',
            text: "<?php echo e(\App\CPU\translate('Sensitive_data! Make_sure_before_changing.')); ?>",
            type: 'warning',
            showCancelButton: true,
            cancelButtonColor: 'default',
            confirmButtonColor: '<?php echo e($web_config['primary_color']); ?>',
            cancelButtonText: 'No',
            confirmButtonText: 'Yes',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                this.submit();
            }else{
                e.preventDefault();
                toastr.success("<?php echo e(\App\CPU\translate('Cancelled')); ?>");
                location.reload();
            }
        })
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/business-settings/db-index.blade.php ENDPATH**/ ?>