<?php $__env->startSection('title',\App\CPU\translate('Chat View')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/css/select2.min.css" rel="stylesheet"/>
    <link href="<?php echo e(asset('public/assets/back-end/css/croppie.css')); ?>" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(\App\CPU\translate('Dashboard')); ?></a></li>
            <li class="breadcrumb-item" aria-current="page"><?php echo e(\App\CPU\translate('Message view')); ?></li>
        </ol>
    </nav>
    <!-- Page Heading -->
    <div class="container">
        <div class="d-sm-flex align-items-center justify-content-between mb-2">
            <h1 class="h3 mb-0 text-black-50"><?php echo e(\App\CPU\translate('View User Message')); ?></h1>
        </div>

        <!-- Content Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body mt-3 ml-4">
                        <div class="row ">
                            <div class="col-md-3 col-lg-3 hidden-xs hidden-sm">
                                <img class="img-circle __inline-21"
                                     src="<?php echo e(asset('public/assets/front-end')); ?>/img/contacts/blank.jpg"
                                     alt="User Pic">
                            </div>

                            <div class=" col-md-9 col-lg-9 hidden-xs hidden-sm">
                                <strong class="mr-3"><?php echo e($contact->subject); ?></strong>
                                <?php if($contact->seen==1): ?>
                                    <label class="__rounded-10 text-success border p-1"><?php echo e(\App\CPU\translate('Seen')); ?></label>
                                <?php else: ?>
                                    <label class="__rounded-10 text-danger border p-1"><?php echo e(\App\CPU\translate('Not Seen Yet')); ?></label>
                                <?php endif; ?>
                                <br>
                                <table class="table table-user-information">
                                    <tbody>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('User name')); ?>:</td>
                                        <td><?php echo e($contact->name); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('Mobile Number')); ?>:</td>
                                        <td><?php echo e($contact->mobile_number); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('Email')); ?>:</td>
                                        <td><?php echo e($contact->email); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('Message')); ?></td>
                                        <td><p class="__text-16px"> <?php echo e($contact->message); ?></p></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <form action="<?php echo e(route('admin.contact.update',$contact->id)); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group" style="display: none">
                                <div class="row">
                                    <div class="col-md-10">
                                        <h4><?php echo e(\App\CPU\translate('Feedback')); ?></h4>
                                        <textarea class="form-control " name="feedback" id="" rows="5"
                                                  placeholder="<?php echo e(\App\CPU\translate('Please send a Feedback')); ?>"><?php echo e($contact->feedback); ?></textarea>
                                    </div>
                                </div>
                            </div>


                            <div class="card-footer">
                                <button type="submit" class="btn btn-success float-right">
                                    <i class="fa fa-check"></i> <?php echo e(\App\CPU\translate('Seen')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/chatting/view.blade.php ENDPATH**/ ?>