<?php $__env->startSection('content'); ?>
    <div class="content container-fluid ">
        <!-- Page Title -->
        <div class="mb-4">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/order_report.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('transaction_table')); ?>

                <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($transactions->total()); ?></span>
            </h2>
        </div>
        <!-- End Page Title -->

        <div class="card">
            <div class="px-3 py-4">
                <div class="row gy-2">
                    <div class="col-xl-3">
                        <form action="" method="GET">
                            <!-- Search -->
                            <div class="input-group input-group-merge input-group-custom">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <i class="tio-search"></i>
                                    </div>
                                </div>
                                <input id="datatableSearch_" type="search" name="search" class="form-control"
                                       placeholder="<?php echo e(\App\CPU\translate('Search by orders id or transaction id')); ?>"
                                       aria-label="Search orders"
                                       value="<?php echo e($search); ?>"
                                       required>
                                <button type="submit"
                                        class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                            </div>
                            <!-- End Search -->
                        </form>
                    </div>
                    <div class="col-xl-9">
                        <form action="#" id="form-data" method="GET">
                            <div
                                class="row  gy-2 align-items-center text-<?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>">
                                <div class="col-md-3">
                                    <div class="">
                                        <select class="js-select2-custom form-control" name="customer_id">
                                            <option class="text-center" value="0">
                                                ---<?php echo e(\App\CPU\translate('select_customer')); ?>---
                                            </option>
                                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option class="text-left text-capitalize"
                                                        value="<?php echo e($customer->id); ?>" <?php echo e($customer->id == $customer_id ? 'selected' : ''); ?>>
                                                    <?php echo e($customer->f_name.' '.$customer->l_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="">
                                        <select class="form-control" name="status">
                                            <option class="text-center" value="0" disabled>
                                                ---<?php echo e(\App\CPU\translate('select_status')); ?>---
                                            </option>
                                            <option class="text-capitalize"
                                                    value="all" <?php echo e($status == 'all'? 'selected' : ''); ?> ><?php echo e(\App\CPU\translate('all')); ?> </option>
                                            <option class="text-capitalize"
                                                    value="disburse" <?php echo e($status == 'disburse'? 'selected' : ''); ?> ><?php echo e(\App\CPU\translate('disburse')); ?> </option>
                                            <option class="text-capitalize"
                                                    value="hold" <?php echo e($status == 'hold'? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('hold')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="">
                                        <input type="date" name="from" value="<?php echo e($from); ?>" id="from_date"
                                               class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="">
                                        <input type="date" value="<?php echo e($to); ?>" name="to" id="to_date" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-12 d-flex justify-content-end gap-2">
                                    <button type="submit" class="btn btn--primary px-4" onclick="formUrlChange(this)"
                                            data-action="<?php echo e(url()->current()); ?>">
                                        <?php echo e(\App\CPU\translate('filter')); ?>

                                    </button>
                                    <div>
                                        <button type="button" class="btn btn--primary text-nowrap btn-block"
                                                data-toggle="dropdown">
                                            <i class="tio-download-to"></i>
                                            <?php echo e(\App\CPU\translate('Export')); ?>

                                            <i class="tio-chevron-down"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li><a class="dropdown-item"
                                                   href="<?php echo e(route('admin.transaction.transaction-export', ['customer_id'=>request('customer_id'), 'status'=>request('status'), 'from'=>request('from'), 'to'=>request('to')])); ?>"  ><?php echo e(\App\CPU\translate('Excel')); ?></a>
                                            </li>
                                            <div class="dropdown-divider"></div>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table id="datatable"
                       style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                       class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                        <th><?php echo e(\App\CPU\translate('seller_name')); ?></th>
                        <th><?php echo e(\App\CPU\translate('customer_name')); ?></th>
                        <th><?php echo e(\App\CPU\translate('order_id')); ?></th>
                        <th><?php echo e(\App\CPU\translate('transaction_id')); ?></th>
                        <th><?php echo e(\App\CPU\translate('order_amount')); ?></th>
                        <th><?php echo e(\App\CPU\translate('seller_amount')); ?></th>
                        <th><?php echo e(\App\CPU\translate('admin_commission')); ?></th>
                        <th><?php echo e(\App\CPU\translate('received_by')); ?></th>
                        <th><?php echo e(\App\CPU\translate('delivered_by')); ?></th>
                        <th><?php echo e(\App\CPU\translate('delivery_charge')); ?></th>
                        <th><?php echo e(\App\CPU\translate('payment_method')); ?></th>
                        <th><?php echo e(\App\CPU\translate('tax')); ?></th>
                        <th><?php echo e(\App\CPU\translate('date')); ?></th>
                        <th><?php echo e(\App\CPU\translate('status')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($transactions->firstItem()+$key); ?></td>
                            <td>
                                <?php if($transaction['seller_is'] == 'admin'): ?>
                                    <?php echo e(\App\CPU\Helpers::get_business_settings('company_name')); ?>

                                <?php else: ?>
                                    <?php if(isset($transaction->seller)): ?>
                                        <?php echo e($transaction->seller->f_name); ?> <?php echo e($transaction->seller->l_name); ?>

                                    <?php else: ?>
                                        <?php echo e(\App\CPU\translate('not_found')); ?>

                                    <?php endif; ?>
                                <?php endif; ?>

                            </td>
                            <td>
                                <?php if(isset($transaction->customer)): ?>
                                    <?php echo e($transaction->customer->f_name); ?> <?php echo e($transaction->customer->l_name); ?>

                                <?php else: ?>
                                    <?php echo e(\App\CPU\translate('not_found')); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($transaction['order_id']); ?></td>
                            <td><?php echo e($transaction['transaction_id']); ?></td>
                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['order_amount']))); ?></td>
                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['seller_amount']))); ?></td>
                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['admin_commission']))); ?></td>
                            <td><?php echo e($transaction['received_by']); ?></td>
                            <td><?php echo e($transaction['delivered_by']); ?></td>
                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['delivery_charge']))); ?></td>
                            <td><?php echo e(str_replace('_',' ',$transaction['payment_method'])); ?></td>
                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['tax']))); ?></td>
                            <td><?php echo e(date('d M Y',strtotime($transaction['created_at']))); ?></td>
                            <td>
                                <?php if($transaction['status'] == 'disburse'): ?>
                                    <span class="badge badge-soft-success">
                                        <?php echo e($transaction['status']); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-soft-warning ">
                                        <?php echo e($transaction['status']); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
                <?php if(count($transactions)==0): ?>
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                             alt="Image Description">
                        <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <!-- Pagination -->
                    <?php echo e($transactions->links()); ?>

                </div>
            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            $('.js-select2-custom').select2();
        });

        $('#from_date,#to_date').change(function () {
            let fr = $('#from_date').val();
            let to = $('#to_date').val();
            if (fr != '') {
                $('#to_date').attr('required', 'required');
            }
            if (to != '') {
                $('#from_date').attr('required', 'required');
            }
            if (fr != '' && to != '') {
                if (fr > to) {
                    $('#from_date').val('');
                    $('#to_date').val('');
                    toastr.error('<?php echo e(\App\CPU\translate('Invalid date range')); ?>!', Error, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            }

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/transaction/list.blade.php ENDPATH**/ ?>