<?php $__env->startSection('title', \App\CPU\translate('Withdraw Request')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/withdraw-icon.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Withdraw')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header flex-wrap gap-2">
                        <h5 class="mb-0 text-capitalize"><?php echo e(\App\CPU\translate('Withdraw Request Table')); ?>

                            <span class="badge badge-soft-dark radius-50 fz-12 ml-1"><?php echo e($withdraw_requests->total()); ?></span>
                        </h5>
                        <select name="withdraw_status_filter" onchange="status_filter(this.value)" class="custom-select max-w-200">
                            <option value="all" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'all'?'selected':''); ?>><?php echo e(\App\CPU\translate('All')); ?></option>
                            <option value="approved" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'approved'?'selected':''); ?>><?php echo e(\App\CPU\translate('Approved')); ?></option>
                            <option value="denied" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'denied'?'selected':''); ?>><?php echo e(\App\CPU\translate('Denied')); ?></option>
                            <option value="pending" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'pending'?'selected':''); ?>><?php echo e(\App\CPU\translate('Pending')); ?></option>
                        </select>
                    </div>

                    <td class="table-responsive">
                        <table id="datatable"
                                style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light thead-50 text-capitalize">
                                <tr>
                                    <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('amount')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('request_time')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('status')); ?></th>
                                    <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if($withdraw_requests->count() > 0): ?>
                                <?php $__currentLoopData = $withdraw_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$withdraw_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($withdraw_requests->firstitem()+$key); ?></td>
                                        <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($withdraw_request['amount']))); ?></td>
                                        <td><?php echo e(date("F jS, Y", strtotime($withdraw_request->created_at))); ?></td>
                                        <td>
                                            <?php if($withdraw_request->approved==0): ?>
                                                <label class="badge badge-soft--primary"><?php echo e(\App\CPU\translate('Pending')); ?></label>
                                            <?php elseif($withdraw_request->approved==1): ?>
                                                <label class="badge badge-soft-success"><?php echo e(\App\CPU\translate('Approved')); ?></label>
                                            <?php else: ?>
                                                <label class="badge badge-soft-danger"><?php echo e(\App\CPU\translate('Denied')); ?></label>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <?php if($withdraw_request->approved==0): ?>
                                                <button id="<?php echo e(route('seller.business-settings.withdraw.cancel', [$withdraw_request['id']])); ?>"
                                                        onclick="close_request('<?php echo e(route('seller.business-settings.withdraw.cancel', [$withdraw_request['id']])); ?>')"
                                                    class="btn btn--primary btn-sm">
                                                    <?php echo e(\App\CPU\translate('close')); ?>

                                                </button>
                                            <?php else: ?>
                                                <span class="btn btn--primary btn-sm disabled">
                                                    <?php echo e(\App\CPU\translate('close')); ?>

                                                </span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <td colspan="5" class="text-center">
                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                                </td>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($withdraw_requests->links()); ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script_2'); ?>
  <script>
      function status_filter(type) {
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.post({
              url: '<?php echo e(route('seller.business-settings.withdraw.status-filter')); ?>',
              data: {
                  withdraw_status_filter: type
              },
              beforeSend: function () {
                  $('#loading').show()
              },
              success: function (data) {
                 location.reload();
              },
              complete: function () {
                  $('#loading').hide()
              }
          });
      }
  </script>

  <script>
      function close_request(route_name) {
          swal({
              title: "<?php echo e(\App\CPU\translate('Are you sure?')); ?>",
              text: "<?php echo e(\App\CPU\translate('Once deleted, you will not be able to recover this')); ?>",
              icon: "<?php echo e(\App\CPU\translate('warning')); ?>",
              buttons: true,
              dangerMode: true,
              confirmButtonText: "<?php echo e(\App\CPU\translate('OK')); ?>",
          })
              .then((willDelete) => {
                  if (willDelete.value) {
                      window.location.href = (route_name);
                  }
              });
      }
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/withdraw/list.blade.php ENDPATH**/ ?>