<?php $__env->startSection('title',\App\CPU\translate('Collect_Cash')); ?>


<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/earning_statictics.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Collect_Cash')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Page Header -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card">
                    <form action="<?php echo e(route('admin.delivery-man.cash-receive', ['id' => $delivery_man->id])); ?>" method="post">
                        <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <h5 class="mb-0 page-header-title d-flex align-items-center gap-2 border-bottom pb-3 mb-3">
                            <i class="tio-money"></i>
                            <?php echo e(\App\CPU\translate('Collect_Cash')); ?>

                        </h5>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="d-flex flex-wrap gap-2 mt-3 title-color" id="chosen_price_div">
                                    <div class="product-description-label"><?php echo e(\App\CPU\translate('Total_Cash_In_Hand')); ?>: </div>
                                    <div class="product-price">
                                        <strong><?php echo e($delivery_man->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($delivery_man->wallet->cash_in_hand)) : 0); ?></strong>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="number" name="amount" class="form-control" placeholder="<?php echo e(\App\CPU\translate('enter_withdraw_amount')); ?>"
                                           required>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-3 justify-content-end">
                            <button type="submit" class="btn btn--primary px-4"><?php echo e(\App\CPU\translate('Receive')); ?></button>
                        </div>

                    </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12 mb-3">
                <!-- Card -->
                <div class="card">
                    <!-- Header -->
                    <div class="px-3 py-4">
                        <div class="d-flex justify-content-between gap-10 flex-wrap align-items-center">
                            <div class="">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <!-- Search -->
                                    <!-- End Search -->
                                </form>
                            </div>

                        </div>
                    </div>
                    <!-- End Header -->

                    <!-- Table -->
                    <div class="table-responsive datatable-custom">
                        <table class="table table-hover table-borderless table-thead-bordered table-align-middle card-table <?php echo e(Session::get('direction') === 'rtl' ? 'text-right' : 'text-left'); ?>">
                            <thead class="thead-light thead-50 text-capitalize table-nowrap">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('delivery_man_name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('amount')); ?></th>
                                <th><?php echo e(\App\CPU\translate('transaction_date')); ?></th>
                            </tr>
                            </thead>

                            <tbody id="set-rows">
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <?php echo e($delivery_man->f_name. ' ' .$delivery_man->l_name); ?>

                                    </td>
                                    <td>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction->credit))); ?>

                                    </td>
                                    <td>
                                        <?php echo e(date_format( $transaction->created_at, 'd-M-Y, h:i:s A')); ?>

                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4">
                                        <div class="text-center p-4">
                                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                            <p class="mb-0"><?php echo e(\App\CPU\translate('No Country Found')); ?></p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo $transactions->links(); ?>

                        </div>
                    </div>
                </div>
                <!-- End Card -->
            </div>
        </div>


    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/delivery-man/earning-statement/collect-cash.blade.php ENDPATH**/ ?>