@extends('layouts.back-end.app')
@section('title', \App\CPU\translate('pet_medical_history'))
@push('css_or_js')
<link href="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
@endpush
<style>
    .image-upload>input {
        display: none;
    }

    .image-upload {
        width: 60px;
    }
</style>
@section('content')
<div class="content container-fluid">
    <!-- Page Title -->
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img width="20" src="{{asset('/public/assets/back-end/img/message.png')}}" alt="">
            {{$pet['pet_name']}}
        </h2>
    </div>
    <div class="row">
        <div class="col-lg-6">
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between">
                    <div>
                        <h5 class="mb-0 text-capitalize">
                            {{\App\CPU\translate('Pet_details')}}
                            <i class="tio-edit cursor-pointer" data-toggle="modal" data-target="#petModal" title="Edit"></i>
                        </h5>
                    </div>
                    <h5>
                        <td>{{\App\CPU\translate('Pet ID')}}#</td>
                        <td>{{$pet['id']}}</td>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#transferHistoryModal" value="{{$pet->id}}" id="historyBtn">{{\App\CPU\translate('Transfer_History')}}</button>
                        <a class="btn btn--primary btn-sm" data-toggle="modal" data-target="#transferModal">{{\App\CPU\translate('Transfer_Pet')}}</a>
                    </div>
                    <table class="table table-user-information table-borderless mb-0">
                        <tbody>
                            @php
                            $dateOfBirth = \Carbon\Carbon::parse($pet['age']);
                            $currentDate = \Carbon\Carbon::now();
                            $age = $dateOfBirth->diff($currentDate);

                            $years = $age->y;
                            $months = $age->m;
                            $days = $age->d;
                            @endphp
                            <tr>
                                <td>{{\App\CPU\translate('name')}}:</td>
                                <td>{{$pet['pet_name']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('type')}}:</td>
                                <td>{{$pet['type']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('breed')}}:</td>
                                <td>{{$pet['breed']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('gender')}}:</td>
                                <td>{{$pet['gender']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('DOB')}}:</td>
                                <td>{{$pet['age']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('City')}}:</td>
                                <td>{{$pet['city']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('age')}}:</td>
                                <td>
                                    {{ $years > 0 ? $years . ' year' . ($years > 1 ? 's' : '') : '' }}
                                    {{ $months > 0 ? ($years > 0 ? ' ' : '') . $months . ' month' . ($months > 1 ? 's' : '') : '' }}
                                    {{ $days > 0 ? ($years > 0 || $months > 0 ? ' ' : '') . $days . ' day' . ($days > 1 ? 's' : '') : '' }}
                                </td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('microchip_id')}}:
                                </td>
                                @if($pet['microchip_id'] != null)
                                <td>
                                    {{$pet['microchip_id']}}
                                    <i class="tio-edit cursor-pointer" data-toggle="modal" data-target="#microchipModal" title="Edit"></i>
                                </td>
                                @else
                                <td>
                                    <i class="text-danger">{{\App\CPU\translate('no_microchip_id_assign')}}</i>
                                    <i class="tio-add cursor-pointer" data-toggle="modal" data-target="#microchipModal" title="Add"></i>
                                </td>
                                @endif

                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card mb-3">
                <div class="card-header">
                    <div>
                        <h5 class="mb-0 text-capitalize d-flex">
                            {{\App\CPU\translate('User_details')}}
                            <i class="tio-edit cursor-pointer ml-2" data-toggle="modal" data-target="#cusModal" title="Edit"></i>
                        </h5>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-user-information table-borderless mb-0">
                        <tbody>
                            <tr>
                                <td>{{\App\CPU\translate('name')}}:</td>
                                <td>{{$pet['customer']['f_name']}} {{$pet['customer']['l_name']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('phone')}}:</td>
                                <td>{{$pet['customer']['phone']}}</td>
                            </tr>
                            <tr>
                                <td>{{\App\CPU\translate('email')}}:</td>
                                <td>{{$pet['customer']['email']}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Tabs -->
    <nav>
        <div class="nav nav-tabs" id="nav-tab" role="tablist">
            <a class="nav-item nav-link active" id="nav-all-tab" data-toggle="tab" href="#nav-all" role="tab" aria-controls="nav-all" aria-selected="true">{{\App\CPU\translate('All')}}</a>
            <a class="nav-item nav-link" id="nav-vaccine-tab" data-toggle="tab" href="#nav-vaccine" role="tab" aria-controls="nav-vaccine" aria-selected="true">{{\App\CPU\translate('Vaccine')}}</a>
            <a class="nav-item nav-link" id="nav-allergy-tab" data-toggle="tab" href="#nav-allergy" role="tab" aria-controls="nav-allergy" aria-selected="false">{{\App\CPU\translate('Allergy')}}</a>
            <a class="nav-item nav-link" id="nav-parasite-tab" data-toggle="tab" href="#nav-parasite" role="tab" aria-controls="nav-parasite" aria-selected="false">{{\App\CPU\translate('Parasites Treatment')}}</a>
            <a class="nav-item nav-link" id="nav-exam-tab" data-toggle="tab" href="#nav-exam" role="tab" aria-controls="nav-exam" aria-selected="false">{{\App\CPU\translate('Examination')}}</a>
            <a class="nav-item nav-link" id="nav-surgery-tab" data-toggle="tab" href="#nav-surgery" role="tab" aria-controls="nav-surgery" aria-selected="false">{{\App\CPU\translate('Surgery')}}</a>
            <a class="nav-item nav-link" id="nav-presc-tab" data-toggle="tab" href="#nav-presc" role="tab" aria-controls="nav-presc" aria-selected="false">{{\App\CPU\translate('Prescription')}}</a>
            <a class="nav-item nav-link" id="nav-labTests-tab" data-toggle="tab" href="#nav-labTests" role="tab" aria-controls="nav-labTests" aria-selected="false">{{\App\CPU\translate('Lab Tests')}}</a>
            <a class="nav-item nav-link" id="nav-radiology-tab" data-toggle="tab" href="#nav-radiology" role="tab" aria-controls="nav-radiology" aria-selected="false">{{\App\CPU\translate('Radiology')}}</a>
            <a class="nav-item nav-link" id="nav-pathology-tab" data-toggle="tab" href="#nav-pathology" role="tab" aria-controls="nav-pathology" aria-selected="false">{{\App\CPU\translate('Pathology')}}</a>
        </div>
    </nav>
    <div class="tab-content" id="nav-tabContent">
        <!-- all -->
        <div class="tab-pane fade show active" id="nav-all" role="tabpanel" aria-labelledby="nav-all-tab">
            <div class="card mt-3">
                <!-- Table -->
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                            <div class="d-flex justify-content-sm-end">
                                <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    {{\App\CPU\translate('export')}}
                                    <i class="tio-chevron-down"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li><a class="dropdown-item" href="{{ route('admin.pet-medical-history.export', $pet['id']) }}">{{\App\CPU\translate('excel')}}</a></li>
                                    <div class="dropdown-divider"></div>
                                </ul>
                            </div>
                        </div>
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('Title')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('type')}}</th>
                                <th>{{\App\CPU\translate('notes')}}</th>
                                <th>{{\App\CPU\translate('Action')}}</th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($all as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    <span class="badge badge-soft-info fz-12">{{$item->type}}</span>
                                </td>
                                <td>{{ strip_tags($item->notes) }}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <a class="btn btn-outline-info btn-sm cursor-pointer" href="{{ route('admin.pet-medical-history.exportbyId', $item['id']) }}" title="{{ \App\CPU\translate('Download')}}">
                                            <i class="tio-download-to"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <!-- Modal 4 -->
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$all->links()}}
                        </div>
                    </div>
                    @if(count($all)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        <!-- vaccine -->
        <div class="tab-pane fade show" id="nav-vaccine" role="tabpanel" aria-labelledby="nav-vaccine-tab">
            <div class="card mt-3">
                <!-- Table -->
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                            <a id="btnAddVaccine" class="btn btn--primary addBtn" data-toggle="modal" data-target="#vaccineModal">
                                <i class="tio-add"></i>
                                <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                            </a>
                            <!-- Modal -->
                            <div class="modal fade" id="vaccineModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Vaccine')}}</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                                @csrf
                                                <div class="form-group">
                                                    <input type="hidden" name="type" value="vaccine" class="form-control">
                                                    <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                                    <input type="hidden" id="vaccineId" name="id" value="" class="form-control">
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-6">
                                                        <label class="title-color">{{ \App\CPU\translate('vaccine_name') }}</label>
                                                        <input type="text" id="vaccineTitle" required name="title" class="form-control" placeholder="Vaccine Name">
                                                    </div>
                                                    <div class="form-group col-6">
                                                        <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                        <input type="date" required id="vaccinedate" name="date" class="form-control" placeholder="date">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="title-color">{{ \App\CPU\translate('next_appointment') }}</label>
                                                    <div class="row row-cols-1 row-cols-md-2">
                                                        <div class="col-md-4 mb-2">
                                                            <input type="number" id="vaccinenext_due_in" name="next_due_in" class="form-control w-100" placeholder="No. of periods">
                                                        </div>
                                                        <select class="js-example-basic-multiple form-control w-25 col-md-3 mb-2" name="period" id="vaccinePeriod">
                                                            <!-- <option value="" selected disabled class="text-black-50">Select Period</option> -->
                                                            @foreach (\App\CPU\Helpers::dateTime() as $x)
                                                            <option value="{{ $x }}" {{ $pet->period == $x ? 'selected' : '' }}>
                                                                {{ $x }}
                                                            </option>
                                                            @endforeach

                                                        </select>
                                                        <div class="col-md-5 mb-2">
                                                            <input type="date" id="vaccineappointdate" name="appointment_date" class="form-control w-100">
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="form-group">
                                                    <label class="title-color">{{ \App\CPU\translate('notes') }}</label>
                                                    <textarea name="notes" cols="30" rows="10" id="vaccinenotes" class="form-control"></textarea>
                                                </div>
                                                <div class="form-group d-flex justify-content-between">
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('vaccine_name')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('next_appointment')}}</th>
                                <th>{{\App\CPU\translate('notes')}}</th>
                                <th>{{\App\CPU\translate('Action')}}</th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($vaccineData as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    @if($item['appointment_date'] != null)
                                    <div>
                                        {{date('d M Y',strtotime($item['appointment_date']))}},
                                    </div>
                                    <div>
                                        {{$item->next_due_in}} {{$item->period}}
                                    </div>
                                    @else
                                    <div>
                                        No any appointment date!
                                    </div>
                                    @endif
                                </td>
                                <td>{{ strip_tags($item->notes) }}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editVaccine" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#vaccineModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <!-- Modal 4 -->
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$vaccineData->links()}}
                        </div>
                    </div>
                    @if(count($vaccineData)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- allergy  -->
        <div class="tab-pane fade" id="nav-allergy" role="tabpanel" aria-labelledby="nav-allergy-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3 mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addAllergy" data-toggle="modal" data-target="#allergyModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- Modal -->
                    <div class="modal fade" id="allergyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Allergy')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="alergy" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="allergyid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('allergy_name') }}</label>
                                            <input required type="text" id="allergytitle" name="title" class="form-control" placeholder="Allergy Name">
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                            <input required type="date" id="allergydate" name="date" class="form-control" placeholder="date">
                                        </div>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- Table -->
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('allergy_name')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('Action')}}</th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($alergy as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button class="btn btn-outline--primary btn-sm square-btn" type="button" id="editAllergy" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#allergyModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$alergy->links()}}
                        </div>
                    </div>
                    @if(count($alergy)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- parasite -->
        <div class="tab-pane fade" id="nav-parasite" role="tabpanel" aria-labelledby="nav-parasite-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addParasite" data-toggle="modal" data-target="#parasiteModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- Modal -->
                    <div class="modal fade" id="parasiteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Parasite_Treatment')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="parasite" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="parasiteid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('parasite_name') }}</label>
                                                <input required name="title" id="parasitetitle" type="text" class="form-control" placeholder="Parasite Name">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required name="date" id="parasitedate" type="date" class="form-control" placeholder="date">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('next_appointment') }}</label>
                                            <div class="row row-cols-1 row-cols-md-2">
                                                <div class="col-md-4 mb-2">
                                                    <input type="number" id="parasitenext_due_in" name="next_due_in" class="form-control w-100" placeholder="No. of periods">
                                                </div>
                                                <select id="parasitePeriod" class="js-example-basic-multiple form-control w-25 col-md-3 mb-2" name="period">
                                                    <!-- <option value="0" id="" selected disabled class="text-black-50">Select Period</option> -->
                                                    @foreach (\App\CPU\Helpers::dateTime() as $x)
                                                    <option value="{{ $x }}">
                                                        {{ $x }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                <div class="col-md-5 mb-2">
                                                    <input type="date" id="parasiteappointdate" name="appointment_date" class="form-control w-100">
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('notes') }}</label>
                                            <textarea style="z-index:10" cols="30" rows="10" name="notes" id="parasitenotes" class="form-control"></textarea>
                                        </div>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Table -->
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('parasite_name')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('next_appointment')}}</th>
                                <th>{{\App\CPU\translate('notes')}}</th>
                                <th>{{\App\CPU\translate('Action')}}</th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($parasite as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    @if($item['appointment_date'] != null)
                                    <div>
                                        {{date('d M Y',strtotime($item['appointment_date']))}},
                                    </div>
                                    <div>
                                        {{$item->next_due_in}} {{$item->period}}
                                    </div>
                                    @else
                                    <div>
                                        No any appointment date!
                                    </div>
                                    @endif
                                </td>
                                <td>{{ strip_tags($item->notes) }}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editParasite" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#parasiteModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$parasite->links()}}
                        </div>
                    </div>
                    @if(count($parasite)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Exam -->
        <div class="tab-pane fade" id="nav-exam" role="tabpanel" aria-labelledby="nav-exam-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addExam" data-toggle="modal" data-target="#examModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- Modal -->
                    <div class="modal fade" id="examModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Examination')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="examination" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="examinationid" name="id" value="examination" class="form-control">
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('temperature') }}</label>
                                                <input required step="0.1" type="number" id="examtemperature" name="tempurature" class="form-control" placeholder="Temperature in °C">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color mx-2">{{ \App\CPU\translate('weight') }}</label>
                                                <input required type="text" id="examweight" name="weight" class="form-control mx-2" placeholder="Weight in Kg" oninput="validateNumber(this);">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('symptoms') }}</label>
                                                <i class="tio-add add_form_field"></i>
                                                <div class="container1">
                                                    <div class="d-flex">
                                                        <input required type="text" id="examsymptoms" name="symptoms[]" class="form-control" placeholder="Symptoms">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color mx-2">{{ \App\CPU\translate('diagnosis') }}</label>
                                                <i class="tio-add add_form_field2"></i>
                                                <div class="container2">
                                                    <div class="d-flex">
                                                        <input required type="text" id="examdiagnosis" name="diagnosis[]" class="form-control mx-2" placeholder="Diagnosis">
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="examdoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="examplace" name="place" class="form-control" placeholder="Place">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="examdate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>


                                        <div>
                                            <div class="form-group">
                                                <label class="title-color">{{ \App\CPU\translate('treatment') }}</label>
                                                <textarea style="z-index:10" cols="15" rows="5" name="treatment" id="examtreatment" class="form-control"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label class="title-color">{{ \App\CPU\translate('note') }}</label>
                                                <textarea style="z-index:10" cols="30" rows="10" name="notes" id="examenotes" class="form-control"></textarea>
                                            </div>
                                            <div class="d-flex">
                                                <div class="form-group image-upload text-center" title="upload image">
                                                    <label for="exam-image-input">
                                                        <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                    </label>
                                                    <input id="exam-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                                </div>
                                                <div class="form-group image-upload text-center" title="upload documents">
                                                    <label for="exam-document-input">
                                                        <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                    </label>
                                                    <input id="exam-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                                </div>

                                                <div class="form-group image-upload text-center" title="upload videos">
                                                    <label for="exam-video-input">
                                                        <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                    </label>
                                                    <input id="exam-video-input" name="video[]" accept="video/*" multiple type="file" />
                                                </div>

                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="exam-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="exam-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="exam-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('temperature')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('weight')}}</th>
                                <th>{{\App\CPU\translate('symptoms')}}</th>
                                <th>{{\App\CPU\translate('diagnosis')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('treatment')}}</th>
                                <th>{{\App\CPU\translate('notes')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($examination as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->tempurature}} °C</td>
                                <td>{{$item->doctor}}</td>
                                <td>{{$item->place}}</td>
                                <td>{{$item->weight}} Kg</td>
                                <td>
                                    @php
                                    $symptoms = explode('>|<', $item->symptoms);
                                        @endphp
                                        @foreach ($symptoms as $symptom)
                                        <div class="mt-2">{{$symptom}}</div>
                                        @endforeach
                                </td>
                                <td>
                                    @php
                                    $diagnosis = explode('>|<',$item->diagnosis)
                                        @endphp
                                        @foreach ($diagnosis as $diagnosisItem)
                                        <div class="mt-2">
                                            {{$diagnosisItem}}
                                        </div>
                                        @endforeach

                                </td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>{{ strip_tags($item->treatment) }}</td>
                                <td>{{ strip_tags($item->notes) }}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editExam" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#examModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>

                    @if(count($examination)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- prescription -->
        <div class="tab-pane fade" id="nav-presc" role="tabpanel" aria-labelledby="nav-presc-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addprescription" data-toggle="modal" data-target="#prescriptionModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- Modal -->

                    <div class="modal fade" id="prescriptionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Prescription')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="prescription" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="prescriptionid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('drug/dose') }}</label>
                                            <i class="tio-add add_prescription_form_field"></i>
                                            <div class="container3">
                                                <div class="d-flex">
                                                    <input required type="text" id="Prescriptiondrug" name="drug[]" class="form-control" placeholder="Drug">
                                                    <input required type="text" id="Prescriptiondose" name="dose[]" class="form-control ml-2" placeholder="Dose">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="prescriptiondoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="prescriptionplace" name="place" class="form-control" placeholder="Place">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="prescriptiondate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('note') }}</label>
                                            <textarea style="z-index:10" cols="30" rows="10" name="notes" id="prescriptionnotes" class="form-control"></textarea>
                                        </div>
                                        <div class="d-flex">
                                            <div class="form-group image-upload text-center" title="upload image">
                                                <label for="prescription-image-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                </label>
                                                <input id="prescription-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                            </div>
                                            <div class="form-group image-upload text-center" title="upload documents">
                                                <label for="prescription-document-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                </label>
                                                <input id="prescription-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                            </div>

                                            <div class="form-group image-upload text-center" title="upload videos">
                                                <label for="prescription-video-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                </label>
                                                <input id="prescription-video-input" name="video[]" accept="video/*" multiple type="file" />
                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="prescription-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="prescription-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="prescription-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('drug/dose')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('note')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        @php
                        $serialNumber = 1;
                        @endphp
                        <tbody>
                            @foreach($prescription as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->doctor}}</td>

                                <td>
                                    @php
                                    $drugParts = explode('<|||>', $item->drug);
                                        @endphp
                                        @foreach($drugParts as $val)
                                        @php
                                        $SubDevided = explode('|>|', $val);

                                        $finalVal = $SubDevided[0] . ' (' . $SubDevided[1] . ')';
                                        echo $finalVal . '</br>' ;
                                        @endphp

                                        @endforeach
                                        <!-- $drug = $drugParts[0];
                                                    $dose = isset($drugParts[1]) ? $drugParts[1] : 'N/A'; -->
                                </td>
                                <!-- Other table data -->

                                <td>{{$item->place}}</td>
                                <td>{{date('d M Y',strtotime($item->date))}}</td>
                                <td>{{$item->notes}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item->id}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editPrescription" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#prescriptionModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>


                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$prescription->links()}}
                        </div>
                    </div>
                    @if(count($prescription)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- lab test -->
        <div class="tab-pane fade" id="nav-labTests" role="tabpanel" aria-labelledby="nav-labTests-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addlabtest" data-toggle="modal" data-target="#labtestModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>

                    <!-- modal -->
                    <div class="modal fade" id="labtestModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Lab Test')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="lab_test" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="labtestid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('test/result/normal') }}</label>
                                            <i class="tio-add add_labtest_form_field"></i>
                                            <div class="container4">
                                                <div class="d-flex parendNewDivLabTest">
                                                    <input required type="text" id="labtest" name="test[]" class="form-control" placeholder="Test">
                                                    <input required type="text" id="labtestresult" name="lab_test_result[]" class="form-control ml-2" placeholder="Result">
                                                    <input required type="text" id="labtestnormal" name="lab_test_normal[]" class="form-control ml-2" placeholder="Normal">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="labtestdoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="labtestplace" name="place" class="form-control" placeholder="Place">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="labtestdate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="title-color">{{ \App\CPU\translate('note') }}</label>
                                            <textarea style="z-index:10" cols="30" rows="10" name="notes" id="labtestnotes" class="form-control"></textarea>
                                        </div>
                                        <div class="d-flex">
                                            <div class="form-group image-upload text-center" title="upload image">
                                                <label for="labTest-image-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                </label>
                                                <input id="labTest-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                            </div>
                                            <div class="form-group image-upload text-center" title="upload documents">
                                                <label for="labTest-document-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                </label>
                                                <input id="labTest-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                            </div>

                                            <div class="form-group image-upload text-center" title="upload videos">
                                                <label for="labTest-video-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                </label>
                                                <input id="labTest-video-input" name="video[]" accept="video/*" multiple type="file" />
                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="labTest-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="labTest-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="labTest-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('test')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('note')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        @php
                        $serialNumber = 1;
                        @endphp
                        <tbody>
                            @foreach($lab_test as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->doctor}}</td>
                                <td>
                                    <!-- Other table data -->
                                    @php
                                    if($item->test != null && $item->test != ""){
                                    $testParts = explode('<|||>', $item->test);
                                        @endphp
                                        @foreach($testParts as $val)
                                        @php
                                        $subDivided = explode('|>|', $val);
                                        $test_name = $subDivided[0];

                                        $alphaParticals = explode('|<|', $subDivided[1]); $test_result=$alphaParticals[0]; $test_normal=$alphaParticals[1]; echo $test_name . ' - ' . $test_result . ' - ' . $test_normal . '</br>' @endphp // <!-- <td>{{ $test_result }}
                                </td>
                                // <td>{{ $test_normal }}</td> -->
                                @endforeach

                                @php
                                }else{
                                echo '-';
                                }
                                @endphp
                                </td>
                                <td>{{$item->place}}</td>
                                <td>{{date('d M Y',strtotime($item->date))}}</td>
                                <td>{{$item->notes}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item->id}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editlab_test" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#labtestModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    @if(count($lab_test)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- surgery -->
        <div class="tab-pane fade" id="nav-surgery" role="tabpanel" aria-labelledby="nav-surgery-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addSurgery" data-toggle="modal" data-target="#surgeryModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- Modal -->
                    <div class="modal fade" id="surgeryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Surgery')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="surgery" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="surgeryid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('title') }}</label>
                                                <input required type="text" id="surgerytitle" name="title" class="form-control" placeholder="Title">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color mx-2">{{ \App\CPU\translate('result') }}</label>
                                                <input required type="text" id="surgeryresult" name="result" class="form-control mx-2" placeholder="Result">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="surgerydoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color mx-2">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="surgeryplace" name="place" class="form-control mx-2" placeholder="Place">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="surgerydate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>

                                        <div class="d-flex">
                                            <div class="form-group image-upload text-center" title="upload image">
                                                <label for="surgery-image-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                </label>
                                                <input id="surgery-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                            </div>
                                            <div class="form-group image-upload text-center" title="upload documents">
                                                <label for="surgery-document-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                </label>
                                                <input id="surgery-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                            </div>

                                            <div class="form-group image-upload text-center" title="upload videos">
                                                <label for="surgery-video-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                </label>
                                                <input id="surgery-video-input" name="video[]" accept="video/*" multiple type="file" />
                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="surgery-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="surgery-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="surgery-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('title')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('result')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($surgery as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{$item->doctor}}</td>
                                <td>{{$item->place}}</td>
                                <td>{{$item->result}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editSurgery" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#surgeryModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$surgery->links()}}
                        </div>
                    </div>
                    @if(count($surgery)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- radiology -->
        <div class="tab-pane fade" id="nav-radiology" role="tabpanel" aria-labelledby="nav-radiology-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addRadiology" data-toggle="modal" data-target="#radiologyModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- modal -->
                    <div class="modal fade" id="radiologyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Radiology')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="radiology" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="radiologyid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('title') }}</label>
                                                <input required type="text" id="radiologytitle" name="title" class="form-control" placeholder="Title">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('result') }}</label>
                                                <input required type="text" id="radiologyresult" name="result" class="form-control" placeholder="Result">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="radiologydoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="radiologyplace" name="place" class="form-control" placeholder="Place">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="radiologydate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="form-group image-upload text-center" title="upload image">
                                                <label for="radiology-image-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                </label>
                                                <input id="radiology-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                            </div>
                                            <div class="form-group image-upload text-center" title="upload documents">
                                                <label for="radiology-document-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                </label>
                                                <input id="radiology-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                            </div>

                                            <div class="form-group image-upload text-center" title="upload videos">
                                                <label for="radiology-video-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                </label>
                                                <input id="radiology-video-input" name="video[]" accept="video/*" multiple type="file" />
                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="radiology-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="radiology-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="radiology-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('title')}}</th>
                                <th>{{\App\CPU\translate('result')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($radiology as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{$item->result}}</td>
                                <td>{{$item->doctor}}</td>
                                <td>{{$item->place}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editRadiology" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#radiologyModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$radiology->links()}}
                        </div>
                    </div>
                    @if(count($radiology)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- pathology -->
        <div class="tab-pane fade" id="nav-pathology" role="tabpanel" aria-labelledby="nav-pathology-tab">
            <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn--primary" id="addPathology" data-toggle="modal" data-target="#pathologyModal">
                        <i class="tio-add"></i>
                        <span class="text">{{\App\CPU\translate('Add_History')}}</span>
                    </a>
                    <!-- modal -->
                    <div class="modal fade" id="pathologyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Pathology')}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{route('admin.pet-medical-history.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="type" value="pathology" class="form-control">
                                            <input type="hidden" name="pet_id" value="{{$pet['id']}}" class="form-control">
                                            <input type="hidden" id="pathologyid" name="id" value="" class="form-control">
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('title') }}</label>
                                                <input required type="text" id="pathologytitle" name="title" class="form-control" placeholder="Title">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('result') }}</label>
                                                <input required type="text" id="pathologyresult" name="result" class="form-control" placeholder="Result">
                                            </div>
                                            <div class="form-group col-4">
                                                <label class="title-color">{{ \App\CPU\translate('doctor') }}</label>
                                                <input type="text" id="pathologydoctor" name="doctor" class="form-control" placeholder="Doctor">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('place') }}</label>
                                                <input type="text" id="pathologyplace" name="place" class="form-control" placeholder="Place">
                                            </div>
                                            <div class="form-group col-6">
                                                <label class="title-color">{{ \App\CPU\translate('date') }}</label>
                                                <input required type="date" id="pathologydate" name="date" class="form-control" placeholder="Date">
                                            </div>
                                        </div>
                                        <div class="d-flex">
                                            <div class="form-group image-upload text-center" title="upload image">
                                                <label for="pathology-image-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/pelfusion/long-shadow-media/128/Camera-icon.png">
                                                </label>
                                                <input id="pathology-image-input" name="images[]" accept="image/png, image/gif, image/jpeg" type="file" multiple />
                                            </div>
                                            <div class="form-group image-upload text-center" title="upload documents">
                                                <label for="pathology-document-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/martz90/circle/128/files-icon.png">
                                                </label>
                                                <input id="pathology-document-input" name="document[]" accept=".pdf,.doc,.docx,.xls,.xlsx" multiple type="file" />
                                            </div>

                                            <div class="form-group image-upload text-center" title="upload videos">
                                                <label for="pathology-video-input">
                                                    <img class="w-50 cursor-pointer" src="https://icons.iconarchive.com/icons/hopstarter/button/128/Button-Play-icon.png">
                                                </label>
                                                <input id="pathology-video-input" name="video[]" accept="video/*" multiple type="file" />
                                            </div>
                                        </div>
                                        <div class="row row-cols-1 row-cols-md-4" id="pathology-image-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4 text-center" id="pathology-document-preview-container"></div><br>
                                        <div class="row row-cols-1 row-cols-md-4" id="pathology-video-preview-container"></div><br>
                                        <div class="form-group d-flex justify-content-between">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('title')}}</th>
                                <th>{{\App\CPU\translate('result')}}</th>
                                <th>{{\App\CPU\translate('doctor')}}</th>
                                <th>{{\App\CPU\translate('place')}}</th>
                                <th>{{\App\CPU\translate('date')}}</th>
                                <th>{{\App\CPU\translate('action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $serialNumber = 1;
                            @endphp
                            @foreach($pathology as $item)
                            <tr>
                                <td>{{$serialNumber}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{$item->result}}</td>
                                <td>{{$item->doctor}}</td>
                                <td>{{$item->place}}</td>
                                <td>{{date('d M Y',strtotime($item['date']))}}</td>
                                <td>
                                    <div class="d-flex gap-10">
                                        <a class="btn btn-outline-danger btn-sm cursor-pointer delete" title="{{ \App\CPU\translate('Delete')}}" id="{{$item['id']}}">
                                            <i class="tio-delete"></i>
                                        </a>
                                        <button id="editPathology" class="btn btn-outline--primary btn-sm square-btn" type="button" title="{{\App\CPU\translate('Edit')}}" value="{{$item->id}}" data-toggle="modal" data-target="#pathologyModal">
                                            <i class="tio-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            @php
                            $serialNumber++;
                            @endphp
                            @endforeach
                        </tbody>
                    </table>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$pathology->links()}}
                        </div>
                    </div>
                    @if(count($pathology)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>



        {{-- Edit Pet Modal --}}
        <div class="modal fade" id="petModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Edit_Pet_Details')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('admin.pet-medical-history.edit/pet-by-history')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{$pet['id']}}">
                            <div class="row">
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Name') }}</label>
                                    <input required type="text" name="name" class="form-control" value="{{$pet['pet_name']}}">
                                </div>
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Type') }}</label>
                                    {{-- <input required type="text" name="type" class="form-control" value="{{$pet['type']}}"> --}}
                                    <select name="type" id="petType" class="js-example-basic-multiple form-control select2">
                                        <option value="Dog" {{ $pet['type'] == "Dog" ? 'selected' : '' }}>{{ \App\CPU\translate('Dog') }}</option>
                                        <option value="Cat" {{ $pet['type'] == "Cat" ? 'selected' : '' }}>{{ \App\CPU\translate('Cat') }}</option>
                                        <option value="Other" {{ $pet['type'] != "Other" &&  $pet['type'] != "Cat" ? 'selected' : '' }}>{{ \App\CPU\translate('Other') }}</option>
                                    </select>
                                </div>
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Breed') }}</label>
                                    {{-- <input required type="text" name="breed" class="form-control" value="{{$pet['breed']}}"> --}}
                                    <select name="breed" id="breedDropdown" class="js-example-basic-multiple form-control select2">
                                        <option value="{{ $pet['breed'] }}" selected>{{ $pet['breed'] }}</option>
                                    </select>
                                </div>
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Gender') }}</label>
                                    <select name="gender" id="" class="js-example-basic-multiple form-control">
                                        <option value="Male" {{$pet['gender'] == "Male" ? "selected" : ""}}>{{ \App\CPU\translate('Male') }}</option>
                                        <option value="Female" {{$pet['gender'] == "Female" ? "selected" : ""}}>{{ \App\CPU\translate('Female') }}</option>
                                        <option value="Other" {{$pet['gender'] != "Female" && $pet['gender'] != "Male" ? "selected" : ""}}>{{ \App\CPU\translate('Other') }}</option>
                                    </select>
                                </div>
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('City') }}</label>
                                    <select name="city" id="" class="js-example-basic-multiple form-control select2">
                                        @foreach ($cities as $city)
                                            <option value="{{ $city }}" {{ $pet['city'] == $city ? 'selected' : '' }}>{{ $city }}</option>
                                        @endforeach
                                    </select>                                    
                                </div>
                                <div class="col-4 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('DOB') }}</label>
                                    <input required type="date" name="dob" class="form-control" value="{{$pet['age']}}">
                                </div>
                                <div class="col-12">
                                    <label class="title-color">{{ \App\CPU\translate('description') }}</label>
                                    <textarea style="z-index:10" cols="30" rows="10" name="description" class="form-control">{{$pet['description']}}</textarea>
                                </div>
                            </div>
                            <div class="form-group d-flex justify-content-between mt-3">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ \App\CPU\translate('Close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ \App\CPU\translate('Save') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        {{-- Edit User Modal --}}
        <div class="modal fade" id="cusModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-md modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Edit_User_Details')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('admin.pet-medical-history.edit/customer-by-history')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{$pet['customer']['id']}}">
                            <div class="row">
                                <div class="col-6 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('First_Name') }}</label>
                                    <input required type="text" name="f_name" class="form-control" value="{{$pet['customer']['f_name']}}">
                                </div>
                                <div class="col-6 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('First_Name') }}</label>
                                    <input required type="text" name="l_name" class="form-control" value="{{$pet['customer']['l_name']}}">
                                </div>
                                <div class="col-6 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Phone') }}</label>
                                    <input required type="text" name="phone" class="form-control" value="{{$pet['customer']['phone']}}">
                                </div>
                                <div class="col-6 my-2">
                                    <label class="title-color">{{ \App\CPU\translate('Email') }}</label>
                                    <input required type="email" name="email" class="form-control" value="{{$pet['customer']['email']}}">
                                </div>
                            </div>
                            <div class="form-group d-flex justify-content-between mt-3">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ \App\CPU\translate('Close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ \App\CPU\translate('Save') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>



        <!-- MOdal of add microchip id -->
        <div class="modal fade" id="microchipModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Microchip')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('admin.pet-medical-history.microchip',[$pet['id']])}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                            </div>
                            <div class="form-group">
                                <label class="title-color">{{ \App\CPU\translate('Microchip_Id') }}</label>
                                <input required type="text" id="allergytitle" name="microchip_id" class="form-control" value="{{$pet['microchip_id']}}" placeholder="Enter Microchip Id">
                            </div>
                            <div class="form-group d-flex justify-content-between">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Modal -->



        <!-- Modal for transfer history of pet -->
        <div class="modal fade" id="transferModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Transfer_Pet')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('admin.pet-medical-history.transfer/pet')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="fromCustomerId" value="{{$pet['customer']['id']}}" class="form-control">
                            <input type="hidden" name="PetId" value="{{$pet['id']}}" class="form-control">
                            <div class="form-group">
                                <label class="title-color">{{ \App\CPU\translate('select_customer') }}</label>
                                <div>
                                    <select name="toCustomerid" class="js-example-basic-multiple select2 form-control w-100 col-md-12 mb-2">
                                        @foreach (\App\CPU\Helpers::customerInfo() as $x)
                                        <option value="{{ $x['id'] }}" {{ $pet['customer']['id'] == $x['id'] ? 'disabled selected class="bg-danger"' : '' }}>
                                            {{ $x["name"] . " | " . $x["email"] . " | " . $x["phone"]  }}
                                        </option>
                                        @endforeach
                                    </select>

                                </div>

                            </div>
                            <div class="form-group d-flex justify-content-between">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal for transfer pet -->

        <div class="modal fade" id="transferHistoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Transfer_History')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100" style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th>{{\App\CPU\translate('SL')}}</th>
                                        <th>{{\App\CPU\translate('pet_name')}}</th>
                                        <th>{{\App\CPU\translate('from_customer')}}</th>
                                        <th>{{\App\CPU\translate('to_customer')}}</th>
                                        <th>{{\App\CPU\translate('transfer_date')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $serialNumber = 1;
                                    @endphp
                                    @foreach($transferHistory as $item)
                                    <tr>
                                        <td>{{$serialNumber}}</td>
                                        <td>{{$item->pet->pet_name}}</td>
                                        <td>{{$item->from_customer->f_name}}</td>
                                        <td>{{$item->to_customer->f_name}}</td>
                                        <td>{{date('d M Y',strtotime($item['created_at']))}}</td>
                                    </tr>

                                    @php
                                    $serialNumber++;
                                    @endphp
                                    @endforeach
                                </tbody>
                            </table>
                            @if(count($transferHistory)==0)
                            <div class="text-center p-4">
                                <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                                <p class="mb-0">{{\App\CPU\translate('No History to show')}}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
    @push('script')
   <script>
    
    var breedsData = [
        {
            "animal": "Dog",
            "breeds": [
                "Affenpinscher",
                "Afghan Hound",
                "Africanis",
                "Aidi",
                "Airedale Terrier",
                "Akbash",
                "Akita",
                "Aksaray Malaklisi",
                "Alano Español",
                "Alapaha Blue Blood Bulldog",
                "Alaskan husky",
                "Alaskan Klee Kai",
                "Alaskan Malamute",
                "Alopekis",
                "Alpine Dachsbracke",
                "American Bulldog",
                "American Bully",
                "American Cocker Spaniel",
                "American English Coonhound",
                "American Eskimo Dog",
                "American Foxhound",
                "American Hairless Terrier",
                "American Leopard Hound",
                "American Pit Bull Terrier",
                "American Staffordshire Terrier",
                "American Water Spaniel",
                "Anglo-Français de Petite Vénerie",
                "Appenzeller Sennenhund",
                "Ariège Pointer",
                "Ariégeois",
                "Argentine Pila",
                "Armant",
                "Armenian Gampr",
                "Artois Hound",
                "Assyrian Mastiff",
                "Australian Cattle Dog",
                "Australian Kelpie",
                "Australian Shepherd",
                "Australian Stumpy Tail Cattle Dog",
                "Australian Terrier",
                "Austrian Black and Tan Hound",
                "Austrian Pinscher",
                "Australian Silky Terrier",
                "Azawakh",
                "Bắc Hà",
                "Bakharwal",
                "Banjara Hound",
                "Bankhar Dog",
                "Barak hound",
                "Barbado da Terceira",
                "Barbet",
                "Basenji",
                "Basque Shepherd Dog",
                "Basset Artésien Normand",
                "Basset Bleu de Gascogne",
                "Basset Fauve de Bretagne",
                "Basset Hound",
                "Bavarian Mountain Hound",
                "Beagle",
                "Beagle-Harrier",
                "Bearded Collie",
                "Beauceron",
                "Bedlington Terrier",
                "Belgian Shepherd",
                "Bergamasco Shepherd",
                "Berger Picard",
                "Bernese Mountain Dog",
                "Bichon Frisé",
                "Biewer Terrier",
                "Billy",
                "Black and Tan Coonhound",
                "Black and Tan Terrier",
                "Black Norwegian Elkhound",
                "Black Russian Terrier",
                "Black Mouth Cur",
                "Bloodhound",
                "Blue Lacy",
                "Blue Picardy Spaniel",
                "Bluetick Coonhound",
                "Boerboel",
                "Bohemian Shepherd",
                "Bolognese",
                "Border Collie",
                "Border Terrier",
                "Borzoi",
                "Boston Terrier",
                "Bouvier des Ardennes",
                "Bouvier des Flandres",
                "Boxer",
                "Boykin Spaniel",
                "Bracco Italiano",
                "Braque d'Auvergne",
                "Braque du Bourbonnais",
                "Braque Français",
                "Braque Saint-Germain",
                "Brazilian Terrier",
                "Briard",
                "Briquet Griffon Vendéen",
                "Brittany",
                "Broholmer",
                "Bruno Jura Hound",
                "Bucovina Shepherd Dog",
                "Bulgarian Hound",
                "Bulgarian Scenthound",
                "Bull Arab",
                "Bull Terrier",
                "Bulldog",
                "Bullmastiff",
                "Bully Kutta",
                "Burgos Pointer",
                "Ca Mè Mallorquí",
                "Ca de Bou",
                "Ca Rater Mallorquí",
                "Cairn Terrier",
                "Calupoh",
                "Campeiro Bulldog",
                "Can de Chira",
                "Can de Palleiro",
                "Canaan Dog",
                "Canadian Eskimo Dog",
                "Cane Corso",
                "Cane di Oropa",
                "Cane Paratore",
                "Cantabrian Water Dog",
                "Cão de Gado Transmontano",
                "Cardigan Welsh Corgi[",
                "Carea Leonés",
                "Carolina Dog",
                "Carpathian Shepherd Dog",
                "Castro Laboreiro Dog",
                "Catahoula Leopard Dog",
                "Catalan Sheepdog",
                "Caucasian Shepherd Dog",
                "Cavalier King Charles Spaniel",
                "Central Asian Shepherd Dog",
                "Český fousek",
                "Český strakatý pes",
                "Cesky Terrier",
                "Chesapeake Bay Retriever",
                "Chien Français Blanc et Noir",
                "Chien Français Blanc et Orange",
                "Chien Français Tricolore",
                "Chihuahua",
                "Chilean Terrier",
                "Chinese Crested Dog",
                "Chinook",
                "Chippiparai",
                "Chongqing",
                "Chortai",
                "Chow Chow",
                "Chukotka sled dog",
                "Cimarrón Uruguayo",
                "Cirneco dell'Etna",
                "Clumber Spaniel",
                "Colombian Fino Hound",
                "Continental bulldog",
                "Corsican Dog",
                "Coton de Tulear",
                "Cretan Hound",
                "Croatian Sheepdog",
                "Curly-coated Retriever",
                "Czechoslovakian Wolfdog",
                "Dachshund",
                "Dalmatian",
                "Dandie Dinmont Terrier",
                "Danish Spitz",
                "Danish–Swedish Farmdog",
                "Denmark Feist",
                "Dingo",
                "Dobermann",
                "Dogo Argentino",
                "Dogo Sardesco",
                "Dogue Brasileiro",
                "Dogue de Bordeaux",
                "Donggyeongi",
                "Drentse Patrijshond",
                "Drever",
                "Dunker",
                "Dutch Shepherd",
                "Dutch Smoushond",
                "East Siberian Laika",
                "East European Shepherd",
                "Ecuadorian Hairless Dog",
                "English Cocker Spaniel",
                "English Foxhound",
                "English Mastiff",
                "English Setter",
                "English Shepherd",
                "English Springer Spaniel",
                "English Toy Terrier (Black & Tan)",
                "Entlebucher Mountain Dog",
                "Erbi Txakur",
                "Estonian Hound",
                "Estrela Mountain Dog",
                "Eurasier",
                "Faroese Sheepdog",
                "Field Spaniel",
                "Fila Brasileiro",
                "Finnish Hound",
                "Finnish Lapphund",
                "Finnish Spitz",
                "Flat-coated Retriever",
                "French Bulldog",
                "French Spaniel",
                "Galgo Español",
                "Gascon Saintongeois",
                "Gaucho sheepdog",
                "Georgian Shepherd",
                "German Hound",
                "German Longhaired Pointer",
                "German Pinscher",
                "German Roughhaired Pointer",
                "German Shepherd",
                "German Shorthaired Pointer",
                "German Spaniel",
                "German Spitz",
                "German Wirehaired Pointer",
                "Giant Schnauzer",
                "Glen of Imaal Terrier",
                "Golden Retriever",
                "Gończy Polski",
                "Gordon Setter",
                "Grand Anglo-Français Blanc et Noir",
                "Grand Anglo-Français Blanc et Orange",
                "Grand Anglo-Français Tricolore",
                "Grand Basset Griffon Vendéen",
                "Grand Bleu de Gascogne",
                "Grand Griffon Vendéen",
                "Great Dane",
                "Greater Swiss Mountain Dog",
                "Greek Harehound",
                "Greek Shepherd",
                "Greenland Dog",
                "Greyhound",
                "Griffon Bleu de Gascogne",
                "Griffon Bruxellois",
                "Griffon Fauve de Bretagne",
                "Griffon Nivernais",
                "Guatemalan Dogo",
                "Gull Dong",
                "Gull Terrier",
                "Hällefors Elkhound",
                "Halden Hound",
                "Hamiltonstövare",
                "Hanover Hound",
                "Harrier",
                "Havanese",
                "Himalayan Sheepdog",
                "Hmong bobtail dog",
                "Hokkaido",
                "Hovawart",
                "Huntaway",
                "Hygen Hound",
                "Ibizan Hound",
                "Icelandic Sheepdog",
                "Indian pariah dog",
                "Indian Spitz",
                "Irish Red and White Setter",
                "Irish Setter",
                "Irish Terrier",
                "Irish Water Spaniel",
                "Irish Wolfhound",
                "Istrian Coarse-haired Hound",
                "Istrian Shorthaired Hound",
                "Italian Greyhound",
                "Jack Russell Terrier",
                "Jagdterrier",
                "Jämthund",
                "Japanese Chin",
                "Japanese Spitz",
                "Japanese Terrier",
                "Jeju",
                "Jonangi",
                "Kai Ken",
                "Kaikadi",
                "Kamchatka Sled Dog",
                "Kangal Shepherd Dog",
                "Kanni",
                "Karakachan",
                "Karelian Bear Dog",
                "Karelo-Finnish Laika",
                "Kars",
                "Karst Shepherd",
                "Keeshond",
                "Kerry Beagle",
                "Kerry Blue Terrier",
                "Khala",
                "King Charles Spaniel",
                "King Shepherd",
                "Kintamani",
                "Kishu",
                "Kokoni",
                "Kombai",
                "Komondor",
                "Kooikerhondje",
                "Koolie",
                "Korean Jindo",
                "Kromfohrländer",
                "Kuchi",
                "Kunming",
                "Kurdish Mastiff",
                "Kuvasz",
                "Labrador Retriever",
                "Lagotto Romagnolo",
                "Lài",
                "Lakeland Terrier",
                "Lancashire Heeler",
                "Landseer",
                "Lapponian Herder",
                "Large Münsterländer",
                "Leonberger",
                "Levriero Sardo",
                "Lhasa Apso",
                "Liangshan Dog",
                "Lithuanian Hound",
                "Lobito Herreño",
                "Löwchen",
                "Lucas Terrier",
                "Lupo Italiano",
                "Mackenzie River husky",
                "Magyar Agár",
                "Mahratta Hound",
                "Majorca Shepherd Dog",
                "Maltese",
                "Manchester Terrier",
                "Maneto",
                "Markiesje",
                "Maremmano-Abruzzese Sheepdog",
                "McNab",
                "Miniature American Shepherd",
                "Miniature Bull Terrier",
                "Miniature Fox Terrier",
                "Miniature Pinscher",
                "Miniature Schnauzer",
                "Molossus of Epirus",
                "Mongrel",
                "Montenegrin Mountain Hound",
                "Moscow Watchdog",
                "Mountain Cur",
                "Mountain Feist",
                "Mudhol Hound",
                "Mudi",
                "Neapolitan Mastiff",
                "Nenets Herding Laika",
                "New Guinea singing dog",
                "New Zealand Heading Dog",
                "Newfoundland",
                "Norfolk Terrier",
                "Norrbottenspets",
                "Northern Inuit Dog",
                "Norwegian Buhund",
                "Norwegian Elkhound",
                "Norwegian Lundehund",
                "Norwich Terrier",
                "Nova Scotia Duck Tolling Retriever",
                "Old Danish Pointer",
                "Old English Sheepdog",
                "Olde English Bulldogge",
                "Otterhound",
                "Pachón Navarro",
                "Pampas Deerhound",
                "Papillon",
                "Parson Russell Terrier",
                "Pastor Garafiano",
                "Pastore della Lessinia e del Lagorai",
                "Patagonian Sheepdog",
                "Patterdale Terrier",
                "Pekingese",
                "Pembroke Welsh Corgi",
                "Perdigueiro Galego",
                "Perro Majorero",
                "Peruvian Hairless Dog",
                "Petit Basset Griffon Vendéen",
                "Petit Bleu de Gascogne",
                "Phalène",
                "Pharaoh Hound",
                "Phu Quoc Ridgeback",
                "Picardy Spaniel",
                "Plummer Terrier",
                "Plott Hound",
                "Podenco Andaluz",
                "Podenco Canario",
                "Podenco Valenciano",
                "Pointer",
                "Poitevin",
                "Polish Greyhound",
                "Polish Hound",
                "Polish Lowland Sheepdog",
                "Pomeranian",
                "Pont-Audemer Spaniel",
                "Poodle",
                "Porcelaine",
                "Portuguese Podengo",
                "Portuguese Pointer",
                "Portuguese Sheepdog",
                "Portuguese Water Dog",
                "Posavac Hound",
                "Pražský Krysařík",
                "Presa Canario",
                "Pudelpointer",
                "Pug",
                "Puli",
                "Pumi",
                "Pungsan",
                "Pyrenean Mastiff",
                "Pyrenean Mountain Dog",
                "Pyrenean Sheepdog",
                "Rafeiro do Alentejo",
                "Rajapalayam",
                "Rampur Greyhound",
                "Rat Terrier",
                "Ratonero Bodeguero Andaluz",
                "Ratonero Murciano",
                "Redbone Coonhound",
                "Rhodesian Ridgeback",
                "Rize Koyun",
                "Romanian Mioritic Shepherd Dog",
                "Romanian Raven Shepherd Dog",
                "Rottweiler",
                "Rough Collie",
                "Russian Spaniel",
                "Russkiy Toy",
                "Russo-European Laika",
                "Ryukyu",
                "Saarloos wolfdog",
                "Sabueso Español",
                "Saint Miguel Cattle Dog",
                "Saint-Usuge Spaniel",
                "Saluki",
                "Samoyed",
                "Sapsali",
                "Sarabi",
                "Sardinian Shepherd Dog",
                "Šarplaninac",
                "Schapendoes",
                "Schillerstövare",
                "Schipperke",
                "Schweizer Laufhund",
                "Schweizerischer Niederlaufhund",
                "Scottish Deerhound",
                "Scottish Terrier",
                "Sealyham Terrier",
                "Segugio dell'Appennino",
                "Segugio Italiano",
                "Segugio Maremmano",
                "Serbian Hound",
                "Serbian Tricolour Hound",
                "Serrano Bulldog",
                "Shar Pei",
                "Shetland Sheepdog",
                "Shiba Inu",
                "Shih Tzu",
                "Shikoku",
                "Shiloh Shepherd",
                "Siberian Husky",
                "Silken Windhound",
                "Sinhala Hound",
                "Skye Terrier",
                "Sloughi",
                "Slovak Rough-haired Pointer",
                "Slovak Cuvac",
                "Slovenský kopov",
                "Smaland Hound",
                "Small Münsterländer[",
                "Smithfield",
                "Smooth Collie",
                "Smooth Fox Terrier",
                "Soft-coated Wheaten Terrier",
                "South Russian Ovcharka",
                "Spanish Mastiff",
                "Spanish Water Dog[",
                "Spino degli Iblei",
                "Spinone Italiano",
                "Sporting Lucas Terrier",
                "St. Bernard",
                "St. Hubert Jura Hound",
                "Stabyhoun",
                "Staffordshire Bull Terrier",
                "Standard Schnauzer",
                "Stephens Stock",
                "Styrian Coarse-haired Hound",
                "Sussex Spaniel",
                "Swedish Lapphund",
                "Swedish Vallhund",
                "Taigan",
                "Taiwan Dog",
                "Tamaskan Dog",
                "Tang Dog",
                "Tarsus çatalburun",
                "Tatra Shepherd Dog",
                "Tazy",
                "Teddy Roosevelt Terrier",
                "Telomian",
                "Tenterfield Terrier",
                "Thai Bangkaew Dog",
                "Thai Ridgeback",
                "Tibetan Kyi Apso",
                "Tibetan Mastiff",
                "Tibetan spaniel",
                "Tibetan Terrier",
                "Tonya Finosu",
                "Tornjak",
                "Tosa",
                "Toy Fox Terrier",
                "Toy Manchester Terrier",
                "Transylvanian Hound",
                "Treeing Cur",
                "Treeing Feist",
                "Treeing Tennessee Brindle",
                "Treeing Walker Coonhound",
                "Trigg Hound",
                "Tyrolean Hound",
                "Valencian Terrier",
                "Vikhan",
                "Villano de Las Encartaciones",
                "Villanuco de Las Encartaciones",
                "Vizsla",
                "Volkosob",
                "Volpino Italiano",
                "Weimaraner",
                "Welsh Hound",
                "Welsh Sheepdog",
                "Welsh Springer Spaniel",
                "Welsh Terrier",
                "West Country Harrier",
                "West Highland White Terrier",
                "West Siberian Laika",
                "Westphalian Dachsbracke",
                "Wetterhoun",
                "Whippet",
                "White Shepherd",
                "White Swiss Shepherd Dog[",
                "Wire Fox Terrier",
                "Wirehaired Pointing Griffon",
                "Wirehaired Vizsla",
                "Xiasi Dog",
                "Xoloitzcuintle",
                "Yakutian Laika",
                "Yorkshire Terrier",
                "Zerdava",
                "Abyssinian sand terrier",
                "Alaunt",
                "Alpine Mastiff",
                "Argentine Polar Dog",
                "Belgian Mastiff",
                "Black and Tan Terrier",
                "Braque Dupuy",
                "Buckhound",
                "Bullenbeisser",
                "Chien-gris",
                "Chiribaya Dog",
                "Córdoba fighting dog",
                "Cumberland Sheepdog",
                "Cur",
                "Dalbo",
                "Dogo Cubano",
                "Dumfriesshire hound",
                "English Water Spaniel",
                "English White Terrier",
                "Fuegian",
                "Grand Fauve de Bretagne",
                "Halls Heeler",
                "Hare Indian Dog",
                "Hawaiian Poi Dog",
                "King's White Hound",
                "Kurī",
                "Lapponian Shepherd",
                "Limer",
                "Marquesan Dog",
                "Molossus",
                "Moscow Water Dog",
                "Norfolk Spaniel",
                "Norman Hound",
                "North Country Beagle",
                "Old Croatian Sighthound",
                "Old English Bulldog",
                "Old Spanish Pointer",
                "Old Welsh Grey Sheepdog",
                "Paisley Terrier",
                "Polynesian Dog",
                "Rache",
                "Rastreador Brasileiro",
                "Sakhalin Husky",
                "Salish Wool Dog",
                "Sleuth hound",
                "Southern Hound",
                "St. John's water dog",
                "Staghound",
                "Tahitian Dog",
                "Tahltan Bear Dog",
                "Talbot",
                "Techichi",
                "Terceira Mastiff",
                "Tesem",
                "Toy Bulldog",
                "Toy Trawler Spaniel",
                "Turnspit",
                "Tweed Water Spaniel",
                "Welsh Hillman"
            ]
        },
        {
            "animal": "Cat",
            "breeds": [
                "Abyssinian",
                "Aegean",
                "American Bobtail",
                "American Curl",
                "American Ringtail",
                "American Shorthair",
                "American Wirehair",
                "Aphrodite Giant",
                "Arabian Mau",
                "Asian",
                "Asian Semi-longhair",
                "Australian Mist",
                "Balinese",
                "Bambino",
                "Bengal",
                "Birman",
                "Bombay",
                "Brazilian Shorthair",
                "British Longhair",
                "British Shorthair",
                "Burmese",
                "Burmilla",
                "California Spangled",
                "Chantilly-Tiffany",
                "Chartreux",
                "Chausie",
                "Colorpoint Shorthair",
                "Cornish Rex",
                "Cymric, Manx Longhair or Long-haired Manx",
                "Cyprus",
                "Devon Rex",
                "Donskoy or",
                "Don Sphynx",
                "Dragon Li or",
                "Chinese Li Hua",
                "Dwelf",
                "Egyptian Mau",
                "European Shorthair",
                "Exotic Shorthair",
                "Foldex",
                "German Rex",
                "Havana Brown",
                "Highlander",
                "Himalayan or",
                "Colorpoint Persian",
                "Japanese Bobtail",
                "Javanese or",
                "Colorpoint Longhair",
                "Kanaani",
                "Khao Manee",
                "Kinkalow",
                "Korat",
                "Korean Bobtail",
                "Korn Ja",
                "Kurilian Bobtail or",
                "Kuril Islands Bobtail",
                "Lambkin",
                "LaPerm",
                "Lykoi",
                "Maine Coon",
                "Manx",
                "Mekong Bobtail",
                "Minskin",
                "Minuet",
                "Munchkin",
                "Nebelung",
                "Neva Masquerade (colorpoint Siberian) ",
                "Norwegian Forest Cat",
                "Ocicat",
                "Ojos Azules",
                "Oregon Rex",
                "(extinct)",
                "Oriental Bicolor",
                "Oriental Longhair",
                "Oriental Shorthair",
                "Persian (modern)",
                "Persian (traditional)",
                "Peterbald",
                "Pixie-bob",
                "Ragamuffin or",
                "Liebling (obsolete)",
                "Ragdoll",
                "Raas",
                "Russian Blue",
                "Russian White, Russian Black and Russian Tabby",
                "Sam Sawet",
                "Savannah",
                "Scottish Fold",
                "Selkirk Rex",
                "Serengeti",
                "Serrade Petit",
                "Siamese (modern)",
                "(for traditional, see Thai below)",
                "Siberian or",
                "Siberian Forest Cat",
                "(for colorpoint, see Neva Masquerade)",
                "Singapura",
                "Snowshoe",
                "Sokoke",
                "Somali",
                "Sphynx",
                "Suphalak",
                "Thai or",
                "Traditional, Classic, or Old-style Siamese;",
                "Wichien Maat[h]",
                "Thai Lilac, Thai Blue Point and Thai Lilac Point",
                "Tonkinese",
                "Toybob",
                "Toyger",
                "Turkish Angora",
                "Turkish Van",
                "Turkish Vankedisi",
                "(white variety of Turkish Van)",
                "Ukrainian Levkoy",
                "York Chocolate"
            ]
        },
        {
            "animal": "Other",
            "breeds": []
        }
    ];
    function populateBreedsDropdown(selectedType) {
        var breedsDropdown = $('#breedDropdown');
        var selectedTypeData = breedsData.find(item => item.animal === selectedType);

        if (selectedTypeData) {
            selectedTypeData.breeds.forEach(breed => {
                breedsDropdown.append($('<option>', {
                    value: breed,
                    text: breed
                }));
            });
        }
    }
    $('#petType').on('change', function () {
        var selectedType = $(this).val();
        populateBreedsDropdown(selectedType);
    });

    var initialSelectedType = $('#petType').val();
    populateBreedsDropdown(initialSelectedType);

   </script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
        $(document).on('click', '.delete', function() {
            var id = $(this).attr("id");
            Swal.fire({
                title: "{{\App\CPU\translate('Are_you_sure_delete_this_history')}}?",
                text: "{{\App\CPU\translate('You_will_not_be_able_to_revert_this')}}!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{\App\CPU\translate('
                Yes ')}}, {{\App\CPU\translate('
                delete_it ')}}!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('admin.pet-medical-history.delete')}}",
                        method: 'POST',
                        data: {
                            id: id
                        },
                        success: function(response) {
                            console.log(response);
                            window.location.reload();
                            $('#data-' + id).hide();
                        }
                    });
                }
            })
        });

        //vaccine
        $(document).on('click', '#btnAddVaccine', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#vaccineId').val("");
            $('#vaccineTitle').val("");
            $('#vaccinedate').val(formattedDate);
            $('#vaccinenext_due_in').val("");
            $('#vaccinenotes').val("");
            $('#vaccineappointdate').val("");
            $('#vaccinePeriod').val('Day');
        });


        $(document).on('click', '#editVaccine', function() {
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#vaccineId').val(id)
                    $('#vaccineTitle').val(response.data.title)
                    $('#vaccinedate').val(response.data.date.split(' ')[0]);
                    $('#vaccinenext_due_in').val(response.data.next_due_in);
                    $('#vaccineappointdate').val(response.data.appointment_date.split('T')[0]);
                    $('#vaccinePeriod').val(response.data.period)
                    $('#vaccinenotes').val(response.data.notes)
                }
            });
        });

        $(function() {
            $("#vaccinedate").on("input", calculateFutureDate).val();
            $("#vaccinePeriod").on("change", calculateFutureDate);
            $("#vaccinenext_due_in").on("input", calculateFutureDate);
            $("#vaccineappointdate").on("input", calculateQuantity); // Add event listener for manually changing the future date

            function calculateFutureDate() {
                var selectedDate = $("#vaccinedate").val();
                var timeUnit = $("#vaccinePeriod").val();
                var quantity = parseInt($("#vaccinenext_due_in").val());

                if (selectedDate && !isNaN(quantity) && quantity >= 0) {
                    var futureDate = new Date(selectedDate);

                    switch (timeUnit) {
                        case "Day":
                            futureDate.setDate(futureDate.getDate() + quantity);
                            break;
                        case "Week":
                            futureDate.setDate(futureDate.getDate() + (quantity * 7));
                            break;
                        case "Month":
                            futureDate.setMonth(futureDate.getMonth() + quantity);
                            break;
                        case "Year":
                            futureDate.setFullYear(futureDate.getFullYear() + quantity);
                            break;
                    }

                    var year = futureDate.getFullYear();
                    var month = String(futureDate.getMonth() + 1).padStart(2, '0');
                    var day = String(futureDate.getDate()).padStart(2, '0');

                    $("#vaccineappointdate").val(`${year}-${month}-${day}`);
                    $("#vaccineappointdate").prop("disabled", false);
                } else {
                    $("#vaccineappointdate").val("");
                    $("#vaccineappointdate").prop("disabled", true);
                }
            }

            function calculateQuantity() {
                var selectedDate = new Date($("#vaccinedate").val());
                var futureDate = new Date($("#vaccineappointdate").val());

                if (selectedDate && futureDate) {
                    var timeUnit = $("#vaccinePeriod").val();
                    var difference = futureDate.getTime() - selectedDate.getTime();

                    switch (timeUnit) {
                        case "Day":
                            $("#vaccinenext_due_in").val(difference / (1000 * 60 * 60 * 24));
                            break;
                        case "Week":
                            $("#vaccinenext_due_in").val(difference / (1000 * 60 * 60 * 24 * 7));
                            break;
                        case "Month":
                            var diffMonths = (futureDate.getFullYear() - selectedDate.getFullYear()) * 12 + (futureDate.getMonth() - selectedDate.getMonth());
                            $("#vaccinenext_due_in").val(diffMonths);
                            break;
                        case "Year":
                            $("#vaccinenext_due_in").val(futureDate.getFullYear() - selectedDate.getFullYear());
                            break;
                    }
                }
            }
        });


        //Alergy
        $(document).on('click', '#addAllergy', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;
            $('#allergyid').val('')
            $('#allergytitle').val('')
            $('#allergydate').val(formattedDate)
        });
        $(document).on('click', '#editAllergy', function() {
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#allergyid').val(id)
                    $('#allergytitle').val(response.data.title)
                    $('#allergydate').val(response.data.date.split(' ')[0])
                }
            });
        });

        //parasite
        $(document).on('click', '#addParasite', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#parasiteid').val("");
            $('#parasitetitle').val("");
            $('#parasitedate').val(formattedDate);
            $('#parasitenext_due_in').val("");
            $('#parasitenotes').val("");
            $('#parasitePeriod').val("Day");
            $('#parasiteappointdate').val("");
        });
        $(document).on('click', '#editParasite', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#parasiteid').val(id)
                    $('#parasitetitle').val(response.data.title)
                    $('#parasitedate').val(response.data.date.split(' ')[0])
                    $('#parasitenext_due_in').val(response.data.next_due_in)
                    $('#parasiteappointdate').val(response.data.appointment_date.split('T')[0]);
                    $('#parasitePeriod').val(response.data.period)
                    $('#parasitenotes').val(response.data.notes)
                }
            });
        });

        $(function() {
            $("#parasitedate").on("input", calculateFutureDate);
            $("#parasitePeriod").on("change", calculateFutureDate);
            $("#parasitenext_due_in").on("input", calculateFutureDate);
            $("#parasiteappointdate").on("input", calculateQuantity); // Add event listener for manually changing the future date

            function calculateFutureDate() {
                var selectedDate = $("#parasitedate").val();
                var timeUnit = $("#parasitePeriod").val();
                var quantity = parseInt($("#parasitenext_due_in").val());

                if (selectedDate && !isNaN(quantity) && quantity >= 0) {
                    var futureDate = new Date(selectedDate);

                    switch (timeUnit) {
                        case "Day":
                            futureDate.setDate(futureDate.getDate() + quantity);
                            break;
                        case "Week":
                            futureDate.setDate(futureDate.getDate() + (quantity * 7));
                            break;
                        case "Month":
                            futureDate.setMonth(futureDate.getMonth() + quantity);
                            break;
                        case "Year":
                            futureDate.setFullYear(futureDate.getFullYear() + quantity);
                            break;
                    }

                    var year = futureDate.getFullYear();
                    var month = String(futureDate.getMonth() + 1).padStart(2, '0');
                    var day = String(futureDate.getDate()).padStart(2, '0');

                    $("#parasiteappointdate").val(`${year}-${month}-${day}`);
                    $("#parasiteappointdate").prop("disabled", false);
                } else {
                    $("#parasiteappointdate").val("");
                    $("#parasiteappointdate").prop("disabled", true);
                }
            }

            function calculateQuantity() {
                var selectedDate = new Date($("#parasitedate").val());
                var futureDate = new Date($("#parasiteappointdate").val());

                if (selectedDate && futureDate) {
                    var timeUnit = $("#parasitePeriod").val();
                    var difference = futureDate.getTime() - selectedDate.getTime();

                    switch (timeUnit) {
                        case "Day":
                            $("#parasitenext_due_in").val(difference / (1000 * 60 * 60 * 24));
                            break;
                        case "Week":
                            $("#parasitenext_due_in").val(difference / (1000 * 60 * 60 * 24 * 7));
                            break;
                        case "Month":
                            var diffMonths = (futureDate.getFullYear() - selectedDate.getFullYear()) * 12 + (futureDate.getMonth() - selectedDate.getMonth());
                            $("#parasitenext_due_in").val(diffMonths);
                            break;
                        case "Year":
                            $("#parasitenext_due_in").val(futureDate.getFullYear() - selectedDate.getFullYear());
                            break;
                    }
                }
            }
        });


        // function clearVaccineFields(){
        //   alert("hello ");
        //   return true;
        // }

        // Examination

        // validate decimal value into weight
        var validNumber = new RegExp(/^\d*\.?\d*$/);
        var lastValid = document.getElementById("examweight").value;

        function validateNumber(elem) {
            if (validNumber.test(elem.value)) {
                lastValid = elem.value;
            } else {
                elem.value = lastValid;
            }
        }

        $(document).on('click', '#addExam', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#examinationid').val("");
            $('#examtemperature').val("");
            $('#examdate').val(formattedDate);
            $('#examweight').val("");
            $('#examdiagnosis').show()
            $('#examsymptoms').show()
            $('#examdoctor').val("");
            $('#examplace').val("");
            $('#examenotes').val("");
            $('#examtreatment').val("");

            // Clear the file inputs
            $('#exam-image-input').val(""); // Clear image input
            $('#exam-video-input').val(""); // Clear video input
            $('#exam-document-input').val(""); // Clear document input

            // Clear the preview containers
            $('#exam-image-preview-container').empty();
            $('#exam-video-preview-container').empty();
            $('#exam-document-preview-container').empty();

            $('.container1 .symtoms').remove();
            $('.container2 .diagnosis').remove();
        });

        $(document).on('click', '#editExam', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#examinationid').val(id)
                    $('#examtemperature').val(response.data.tempurature)
                    $('#examdate').val(response.data.date.split(' ')[0])
                    $('#examweight').val(response.data.weight)
                    $('#examdiagnosis').hide()
                    $('#examsymptoms').hide()
                    $('#examdiagnosis').prop('disabled', true);
                    $('#examsymptoms').prop('disabled', true);

                    $('#examdoctor').val(response.data.doctor)
                    $('#examplace').val(response.data.place)
                    $('#examenotes').val(response.data.notes)
                    $('#examtreatment').val(response.data.treatment)
                    var symptomsArray = response.data.symptoms.split('>|<');
                    var slicedSymptoms = symptomsArray.slice(1);
                    $(".container1 .d-flex:gt(0)").remove();
                    symptomsArray.forEach(function(symptom) {
                        var newDiv = $('<div class="symtoms d-flex mt-2"></div>');
                        var newInput = $('<input type="text" name="symptoms[]" class="form-control" placeholder="Symptoms"/>');
                        var deleteButton = $('<i class="deleteInput tio-delete"></i>');
                        var modifiedSymptom = symptom;
                        newInput.val(modifiedSymptom);
                        newDiv.append(newInput);
                        newDiv.append(deleteButton);
                        $('.container1').append(newDiv);
                    });

                    debugger

                    var diagnosisArray = response.data.diagnosis.split('>|<');
                    var slicediagnosis = diagnosisArray.slice(1)
                    $(".container2 .d-flex:gt(0)").remove();
                    diagnosisArray.forEach(function(diagnosis) {
                        var newDiv = $('<div class="diagnosis d-flex mt-2"></div>');
                        var newInput = $('<input type="text" name="diagnosis[]" class="form-control" placeholder="Diagnosis"/>');
                        var deleteButton = $('<i class="deleteInputdiagnosis tio-delete"></i>');
                        var modifiedDiagnosis = diagnosis;
                        newInput.val(modifiedDiagnosis);
                        newDiv.append(newInput);
                        newDiv.append(deleteButton);
                        $('.container2').append(newDiv);
                    });

                    $(document).ready(function() {
                        const imagePreviewContainer = $("#exam-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#exam-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#exam-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });



                }
            });
        });



        $(document).ready(function() {
            var wrapper = $(".container1");
            var add_button = $(".add_form_field");
            var minFeild = 1;
            try {

                function updateInputs() {
                    if (x > max_fields) {
                        console.log("Removing elements");
                        wrapper.children('.d-flex:gt(0)').remove();
                        x = 1;
                    }
                }
            } catch (error) {
                console.log(error)
            }


            $(document).on('click', '#addExam', function() {
                debugger;
                max_fields = 1;
                try {

                    updateInputs();
                } catch (error) {
                    console.log(error)
                }
                console.log("addExam button clicked");
            });

            var x = 1;
            $(add_button).click(function(e) {
                e.preventDefault();
                x++;
                $(wrapper).append('<div class="d-flex mt-2"><input type="text" name="symptoms[]" class="form-control" placeholder="Symptoms"/><i class="deleteInput tio-delete"></i></div>');
                console.log("New input added");
            });

            $(wrapper).on("click", ".deleteInput", function(e) {
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
                console.log("Input deleted");
            });
        });



        $(document).ready(function() {
            var wrapper = $(".container2");
            var add_button = $(".add_form_field2");
            var minFeild = 1;

            function updateInputs() {
                if (x > max_fields) {
                    wrapper.children('.d-flex:gt(0)').remove();
                    x = 1;
                }
            }
            $(document).on('click', '#addExam', function() {
                max_fields = 1;
                updateInputs();
            })
            var x = 1;
            $(add_button).click(function(e) {
                e.preventDefault();
                x++;
                $(wrapper).append('<div class="d-flex mt-2"><input type="text" name="diagnosis[]" class="form-control" placeholder="Diagnosis"/><i class="deleteInputdiagnosis tio-delete"></i></div>');
            });
            $(wrapper).on("click", ".deleteInputdiagnosis", function(e) {
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            });
        });

        $(document).ready(function() {
            const fileInput = $("#exam-image-input");
            const imagePreviewContainer = $("#exam-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });

        $(document).ready(function() {
            const videoInput = $("#exam-video-input");
            const videoPreviewContainer = $("#exam-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#exam-document-input");
            const documentPreviewContainer = $("#exam-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });

        // lab test

        $(document).on('click', '#addlabtest', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            // var removedLabTestResult = $('#labtestresult').prop('outerHTML');

            $('#labtestid').val("");
            $('#examdiagnosis').add()
            $('#examsymptoms').add()
            $('#labtest').show();
            $('#labtestresult').show();
            $('#labtestnormal').show();
            $('#labtestdoctor').val("");
            $('#labtestplace').val("");
            $('#labtestdate').val(formattedDate);
            $('#labtestnotes').val("");

            $('#labTest-image-input').val(""); // Clear image input
            $('#labTest-video-input').val(""); // Clear video input
            $('#labTest-document-input').val(""); // Clear document input

            // Clear the preview containers
            $('#labTest-image-preview-container').empty();
            $('#labTest-video-preview-container').empty();
            $('#labTest-document-preview-container').empty();

            $('.container4 .newDivLabTest').remove();
        });

        $(document).on('click', '#editlab_test', function() {
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#labtestid').val(id);
                    $('#labtestdoctor').val(response.data.doctor);
                    $('#labtestplace').val(response.data.place);
                    $('#labtestdate').val(response.data.date.split(' ')[0]);
                    $('#labtestnotes').val(response.data.notes);
                    // $('#labTest-image-input').val(response.data.images.split('>|<'))
                    // $('#labTest-document-input').val(response.data.document.split('>|<'))
                    // $('#labTest-video-input').val(response.data.video.split('>|<'))
                    $('#labtest').hide();
                    $('#labtestresult').hide();
                    $('#labtestnormal').hide();
                    // To disable the elements
                    $('#labtest').prop('disabled', true);
                    $('#labtestresult').prop('disabled', true);
                    $('#labtestnormal').prop('disabled', true);


                    // $('.parendNewDivLabTest').hide()

                    var combinedTestArray = response.data.test.split('<|||>');
                    $(".container4 .d-flex:gt(0)").remove();

                    combinedTestArray.forEach(function(testResultNormal) {
                        var parts = testResultNormal.split('|>|');
                        var test = parts[0];
                        var resultNormal = parts[1].split('|<|');

                        var result = resultNormal[0];
                        var normal = resultNormal[1];

                        var newDiv = $('<div class="newDivLabTest d-flex mt-2"></div>');
                        var testInput = $('<input  required type="text" name="test[]" class="form-control" placeholder="Test">');
                        var resultInput = $('<input  required type="text" name="lab_test_result[]" class="form-control ml-2" placeholder="Result">');
                        var normalInput = $('<input  required type="text" name="lab_test_normal[]" class="form-control ml-2" placeholder="Normal">');
                        var deleteButton = $('<i class="deleteInputlabtest tio-delete"></i>');

                        testInput.val(response.data.place.split('|>|')[0]);
                        resultInput.val(result);
                        normalInput.val(normal);

                        newDiv.append(testInput);
                        newDiv.append(resultInput);
                        newDiv.append(normalInput);
                        newDiv.append(deleteButton);

                        // Append the newDiv to the container
                        $('.container4').append(newDiv);
                    });

                    $(document).ready(function() {
                        const imagePreviewContainer = $("#labTest-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#labTest-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#labTest-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });
                }
            });
        });


        $(document).ready(function() {
            var wrapper = $(".container4");
            var add_button = $(".add_labtest_form_field");
            var minFeild = 1;

            function updateInputs() {
                if (x > max_fields) {
                    wrapper.children('.d-flex:gt(0)').remove();
                    x = 1;
                }
            }
            $(document).on('click', '#addlabtest', function() {
                max_fields = 1;
                updateInputs();
            })

            var x = 1;
            $(add_button).click(function(e) {
                e.preventDefault();
                x++;
                $(wrapper).append('<div class="d-flex mt-2"><input required type="text" name="test[]" class="form-control" placeholder="Test"> <input required type="text" name="lab_test_result[]" class="form-control ml-2" placeholder="Result"><input required type="text" name="lab_test_normal[]" class="form-control ml-2" placeholder="Normal"><i class="deleteInputlabtest tio-delete"></i></div>');
            });

            $(wrapper).on("click", ".deleteInputlabtest", function(e) {
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            });
        });

        $(document).ready(function() {
            const fileInput = $("#labTest-image-input");
            const imagePreviewContainer = $("#labTest-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });
        $(document).ready(function() {
            const videoInput = $("#labTest-video-input");
            const videoPreviewContainer = $("#labTest-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#labTest-document-input");
            const documentPreviewContainer = $("#labTest-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });

        // prescription
        $(document).on('click', '#addprescription', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            debugger

            $('#prescriptionid').val("");
            $('#Prescriptiondrug').show();
            $('#Prescriptiondose').show();
            $('#prescriptiondoctor').val("");
            $('#prescriptionplace').val("");
            $('#prescriptiondate').val(formattedDate);
            $('#prescriptionnotes').val("");

            // Clear the file inputs
            $('#prescription-image-input').val(""); // Clear image input
            $('#prescription-video-input').val(""); // Clear video input
            $('#prescription-document-input').val(""); // Clear document input

            // Clear the preview containers
            $('#prescription-image-preview-container').empty();
            $('#prescription-video-preview-container').empty();
            $('#prescription-document-preview-container').empty();

            // Show the parent input fields

            $('.container3 .addprescription').remove();
        });


        $(document).on('click', '#editPrescription', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#prescriptionid').val(id)
                    $('#prescriptiondoctor').val(response.data.doctor)
                    $('#prescriptionplace').val(response.data.place)
                    $('#examplace').val(response.data.place)
                    $('#prescriptiondate').val(response.data.date.split(' ')[0])
                    $('#prescriptionnotes').val(response.data.notes)
                    // $('#prescription-image-input').val(response.data.images.split('>|<'))
                    // $('#prescription-document-input').val(response.data.document.split('>|<'))
                    // $('#prescription-video-input').val(response.data.video.split('>|<'))
                    $('#Prescriptiondrug').hide();
                    $('#Prescriptiondose').hide();
                    $('#Prescriptiondrug').prop('disabled', true);
                    $('#Prescriptiondose').prop('disabled', true);

                    var drugArray = response.data.drug.split('<|||>');
                    $(".container3 .d-flex:gt(0)").remove();

                    // Iterate through the drugArray and append input fields
                    drugArray.forEach(function(drugAndDose) {
                        // Split the drugAndDose into separate drug and dose parts
                        var parts = drugAndDose.split('|>|');
                        var drug = parts[0];
                        var dose = parts[1];

                        var newDiv = $('<div class="d-flex mt-2 addprescription"></div>');
                        var newInput = $('<input  required type="text" name="drug[]" class="form-control" placeholder="Drug">');
                        var doseInput = $('<input  required type="text" name="dose[]" class="form-control ml-2" placeholder="Dose">');
                        var deleteButton = $('<i class="deleteInputdrugdose tio-delete"></i>');

                        // Set values for drug and dose inputs
                        newInput.val(drug);
                        doseInput.val(dose);

                        // Append input fields and delete button to the newDiv
                        newDiv.append(newInput);
                        newDiv.append(doseInput);
                        newDiv.append(deleteButton);

                        // Append the newDiv to the container
                        $('.container3').append(newDiv);
                    });
                    $(document).ready(function() {
                        const imagePreviewContainer = $("#prescription-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#prescription-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#prescription-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });
                }
            });
        });


        $(document).ready(function() {
            var wrapper = $(".container3");
            var add_button = $(".add_prescription_form_field");
            var minFeild = 1;

            function updateInputs() {
                if (x > max_fields) {
                    wrapper.children('.d-flex:gt(0)').remove();
                    x = 1;
                }
            }
            $(document).on('click', '#addprescription', function() {
                max_fields = 1;
                updateInputs();
            })

            var x = 1;
            $(add_button).click(function(e) {
                e.preventDefault();
                x++;
                $(wrapper).append('<div class="d-flex mt-2"><input required type="text" id="Prescriptiondrug" name="drug[]" class="form-control" placeholder="Drug"><input required type="text" id="Prescriptiondose" name="dose[]" class="form-control ml-2" placeholder="Dose"><i class="deleteInputdrugdose tio-delete"></i></div>');
            });

            $(wrapper).on("click", ".deleteInputdrugdose", function(e) {
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            });
        });

        $(document).ready(function() {
            const fileInput = $("#prescription-image-input");
            const imagePreviewContainer = $("#prescription-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });
        $(document).ready(function() {
            const videoInput = $("#prescription-video-input");
            const videoPreviewContainer = $("#prescription-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#prescription-document-input");
            const documentPreviewContainer = $("#prescription-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });



        // surgery
        $(document).on('click', '#addSurgery', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#surgeryid').val("");
            $('#surgerytitle').val("");
            $('#surgeryresult').val("");
            $('#surgerydoctor').val("");
            $('#surgeryplace').val("");
            $('#surgerydate').val(formattedDate);

            // Clear the file inputs
            $('#surgery-image-input').val(""); // Clear image input
            $('#surgery-document-input').val(""); // Clear document input
            $('#surgery-video-input').val(""); // Clear video input

            // Clear the preview containers
            $('#surgery-image-preview-container').empty();
            $('#surgery-video-preview-container').empty();
            $('#surgery-document-preview-container').empty();
        });

        $(document).on('click', '#editSurgery', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#surgeryid').val(id)
                    $('#surgerytitle').val(response.data.title)
                    $('#surgeryresult').val(response.data.result)
                    $('#surgerydoctor').val(response.data.doctor)
                    $('#surgeryplace').val(response.data.place)
                    $('#surgerydate').val(response.data.date.split(' ')[0])

                    $(document).ready(function() {
                        const imagePreviewContainer = $("#surgery-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#surgery-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#surgery-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });
                }
            });
        });

        $(document).ready(function() {
            const fileInput = $("#surgery-image-input");
            const imagePreviewContainer = $("#surgery-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });
        $(document).ready(function() {
            const videoInput = $("#surgery-video-input");
            const videoPreviewContainer = $("#surgery-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#surgery-document-input");
            const documentPreviewContainer = $("#surgery-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });


        // radiology

        $(document).on('click', '#addRadiology', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#radiologyid').val("");
            $('#radiologytitle').val("");
            $('#radiologyresult').val("");
            $('#radiologydoctor').val("");
            $('#radiologydoctor').val("");
            $('#radiologyplace').val("");
            $('#radiologydate').val(formattedDate);

            $('#radiology-image-input').val(""); // Clear image input
            $('#radiology-video-input').val(""); // Clear video input
            $('#radiology-document-input').val(""); // Clear document input

            // Clear the preview containers
            $('#radiology-image-preview-container').empty();
            $('#radiology-document-preview-container').empty();
            $('#radiology-video-preview-container').empty();
        });
        $(document).on('click', '#editRadiology', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#radiologyid').val(id)
                    $('#radiologytitle').val(response.data.title)
                    $('#radiologyresult').val(response.data.result)
                    $('#radiologydoctor').val(response.data.doctor)
                    $('#radiologyplace').val(response.data.place)
                    $('#radiologydate').val(response.data.date.split(' ')[0])

                    $(document).ready(function() {
                        const imagePreviewContainer = $("#radiology-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#radiology-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#radiology-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });
                }
            });
        });

        $(document).ready(function() {
            const fileInput = $("#radiology-image-input");
            const imagePreviewContainer = $("#radiology-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });
        $(document).ready(function() {
            const videoInput = $("#radiology-video-input");
            const videoPreviewContainer = $("#radiology-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#radiology-document-input");
            const documentPreviewContainer = $("#radiology-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });

        // pathology
        $(document).on('click', '#addPathology', function() {
            var currentDate = new Date();
            var day = currentDate.getDate();
            var month = currentDate.getMonth() + 1;
            var year = currentDate.getFullYear();
            var formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;

            $('#pathologyid').val("");
            $('#pathologytitle').val("");
            $('#pathologyresult').val("");
            $('#pathologydoctor').val("");
            $('#pathologyplace').val("");
            $('#pathologydate').val(formattedDate);

            $('#pathology-image-input').val(""); // Clear image input
            $('#pathology-document-input').val(""); // Clear document input
            $('#pathology-video-input').val(""); // Clear video input

            // Clear the preview containers
            $('#pathology-image-preview-container').empty();
            $('#pathology-video-preview-container').empty();
            $('#pathology-document-preview-container').empty();
        });
        $(document).on('click', '#editPathology', function() {
            debugger
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('#pathologyid').val(id)
                    $('#pathologytitle').val(response.data.title)
                    $('#pathologyresult').val(response.data.result)
                    $('#pathologydoctor').val(response.data.doctor)
                    $('#pathologyplace').val(response.data.place)
                    $('#pathologydate').val(response.data.date.split(' ')[0])

                    $(document).ready(function() {
                        const imagePreviewContainer = $("#pathology-image-preview-container");
                        var imageArray = response.data.images.split('>|<');
                        imagePreviewContainer.empty();

                        // Loop through the image URLs from the response
                        imageArray.forEach(function(imgUrl) {
                            // Check if the image URL is not empty
                            if (imgUrl.trim() !== "") {
                                const img = $("<img>")
                                    .addClass("preview-image rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", imgUrl);
                                imagePreviewContainer.append(img);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const videoPreviewContainer = $("#pathology-video-preview-container");
                        var videoArray = response.data.video.split('>|<');
                        videoPreviewContainer.empty();

                        // Loop through the video URLs from the response
                        videoArray.forEach(function(videoUrl) {
                            // Check if the video URL is not empty
                            if (videoUrl.trim() !== "") {
                                const video = $("<video controls>")
                                    .addClass("preview-video  rounded img-fluid img-thumbnail w-100") // Add ml-2 class here if needed
                                    .attr("src", videoUrl);
                                videoPreviewContainer.append(video);
                            }
                        });
                    });

                    $(document).ready(function() {
                        const documentPreviewContainer = $("#pathology-document-preview-container");
                        var documentArray = response.data.document.split('>|<');

                        // Clear the existing document previews
                        documentPreviewContainer.empty();

                        // Loop through the document links from the response
                        documentArray.forEach(function(documentLink) {
                            // Check if the document link is not empty
                            if (documentLink.trim() !== "") {
                                const iconLink = $("<a>")
                                    .attr("href", documentLink)
                                    .attr("target", "_blank"); // Open link in a new tab
                                const icon = $("<h1>")
                                    .addClass("preview-document bi bi-file-earmark text-primary w-100"); // Replace with the appropriate Bootstrap icon class

                                iconLink.append(icon);
                                documentPreviewContainer.append(iconLink);
                            }
                        });
                    });
                }
            });
        });

        $(document).ready(function() {
            const fileInput = $("#pathology-image-input");
            const imagePreviewContainer = $("#pathology-image-preview-container");

            fileInput.on("change", function() {
                // Clear the existing image previews
                imagePreviewContainer.empty();

                // Loop through the selected files
                $.each(fileInput[0].files, function(index, file) {
                    if (file.type.startsWith('image/')) {
                        const img = $("<img>")
                            .addClass("preview-image rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        imagePreviewContainer.append(img);
                    }
                });
            });
        });
        $(document).ready(function() {
            const videoInput = $("#pathology-video-input");
            const videoPreviewContainer = $("#pathology-video-preview-container");

            videoInput.on("change", function() {
                // Clear the existing video previews
                videoPreviewContainer.empty();

                // Loop through the selected files
                $.each(videoInput[0].files, function(index, file) {
                    if (file.type.startsWith('video/')) {
                        const video = $("<video controls>")
                            .addClass("preview-video  rounded img-fluid img-thumbnail w-100")
                            .attr("src", URL.createObjectURL(file));
                        videoPreviewContainer.append(video);
                    }
                });
            });
        });

        $(document).ready(function() {
            const documentInput = $("#pathology-document-input");
            const documentPreviewContainer = $("#pathology-document-preview-container");

            documentInput.on("change", function() {
                // Clear the existing document previews
                documentPreviewContainer.empty();

                // Loop through the selected files
                $.each(documentInput[0].files, function(index, file) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();

                    // Check if it's a document file based on extension
                    if (['pdf', 'doc', 'docx', 'xls', 'xlsx'].includes(fileExtension)) {
                        const document = $("<div>")
                            .addClass("preview-document")
                            .text(file.name);
                        documentPreviewContainer.append(document);
                    }
                });
            });
        });


        // 
    </script>
    {{-- ck editor --}}
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '{{ Session::get('
            direction ') }}',
        });
    </script>

    {{-- ck editor --}}
    @endpush