<!-- Edited by dSMART -->
@extends('layouts.back-end.app')
@section('title', \App\CPU\translate('Pet-Listing Approval'))
@push('css_or_js')
    <link href="{{ asset('public/assets/back-end') }}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="{{ asset('/public/assets/back-end/img/message.png') }}" alt="">
                {{ \App\CPU\translate('Pet Listing Approval') }}
                <span class="badge badge-soft-dark radius-50 fz-14 ml-1">{{ $pet->total() }}</span>
            </h2>
        </div>
        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row justify-content-between align-items-center flex-grow-1">
                            <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                                <h5 class="d-flex gap-2 align-items-center">
                                    {{ \App\CPU\translate('Pet') }} {{ \App\CPU\translate('Listing') }}
                                    {{ \App\CPU\translate('Approval') }}
                                    <span class="badge badge-soft-dark radius-50 fz-12"></span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <!-- Search -->
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <!-- Edited by dSMART -->
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                            placeholder="{{ \App\CPU\translate('Search_by_Pet_Name') }}"
                                            aria-label="Search orders">

                                        <!-- Edited by dSMART -->
                                        <button type="submit" class="btn btn--primary">search
                                        </button>
                                    </div>
                                </form>
                                <!-- End Search -->
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="datatable"
                            style="text-align: {{ Session::get('direction') === 'rtl' ? 'right' : 'left' }};"
                            class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                                <tr>
                                    <th>{{ \App\CPU\translate('SL') }}</th>
                                    <th>{{ \App\CPU\translate('Owner_Name') }}</th>
                                    <th>{{ \App\CPU\translate('Phone_no.') }}</th>
                                    <th>{{ \App\CPU\translate('Pet') }}</th>
                                    <th>{{ \App\CPU\translate('Gender') }}/{{ \App\CPU\translate('Age') }}</th>
                                    <th>{{ \App\CPU\translate('Breed') }}</th>
                                    <th>{{ \App\CPU\translate('Listing_Type') }}</th>
                                    <th>{{ \App\CPU\translate('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $serialNumber = 1;
                                @endphp
                                @foreach ($pet as $pets)
                                    <tr>
                                        <td>{{ $serialNumber }}</td>
                                        <td>
                                            <a>{{ $pets['owner_name']}}</a>
                                        </td>
                                        <td>{{ $pets['phone'] }}</td>
                                        <td class="overflow-hidden">
                                            <button type="button" value="{{ $pets->id }}"
                                                class="border-0 text-info bg-soft-info font-weight-bold fz-12"
                                                data-toggle="modal" data-target="#petModal"id="viewPet">
                                                <div>{{ $pets['pet_name'] }},</div>
                                                <div>{{ $pets['type'] }}</div>
                                            </button>
                                        </td>
                                        <td class="text-wrap">
                                            <div>{{ $pets['gender'] }}</div>
                                            <div>{{ $pets['age'] }} {{ $pets['age_period'] }}</div>
                                        </td>
                                        <td class="text-wrap">{{ $pets['breed'] }}</td>
                                        <td class="text-wrap">{{ $pets['listing_type'] }}</td>
                                        <td>
                                            <button class="btn btn-success"
                                                onclick="change_status({{ $pets['id'] }}, 1)">Approve</button>
                                            <button class="btn btn-danger"
                                                onclick="change_status({{ $pets['id'] }}, 0)">Deny</button>
                                        </td>

                                    </tr>
                                    @php
                                        $serialNumber++;
                                    @endphp
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{ $pet->links() }}
                        </div>
                    </div>

                    <!-- Show info modal of pet -->

                    <div class="modal fade" id="petModal" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalCenterTitle" aria-hidden="true" data-backdrop="static"
                        data-keyboard="false">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">
                                        {{ \App\CPU\translate('Pet_Details') }}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="table-responsive">
                                        <div class="card mb-3">
                                            <div class="card-body petDet">
                                                <table class="table table-user-information table-borderless mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('name') }}:</td>
                                                            <input type="hidden" id="id"
                                                                value="{{ $pet['id'] }}" class="d-none"></input>
                                                            <td class="ml-5" id="petName">{{ $pet['pet_name'] }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('type') }}:</td>
                                                            <td class="ml-5" id="petType"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('breed') }}:</td>
                                                            <td class="ml-5" id="petBreed"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('gender') }}:</td>
                                                            <td class="ml-5" id="petGender"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('age') }}:</td>
                                                            <td class="ml-5">
                                                                <span id="petAge"></span>
                                                                <span class="" id="petAgePeriod"></span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="font-weight-bold ml-5">
                                                                {{ \App\CPU\translate('listing_type') }}:</td>
                                                            <td class="ml-5" id="petListingType"></td>
                                                        </tr>
                                                        <tr>
                                                            <img id="petImg" class="w-25 rounded mx-auto d-block"
                                                                alt="Pet Image"></img>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="loading-spinner text-center">
                                                <i class="spinner-border text--primary"></i>
                                                <span>Loading...</span>
                                            </div>
                                            <div class="card-footer d-flex justify-content-between petDet">
                                                <button class="btn btn-danger den">Deny</button>
                                                <button class="btn btn-success apr">Approve</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>


                    @if (count($pet) == 0)
                        <div class="text-center p-4">
                            <img class="mb-3 w-160"
                                src="{{ asset('public/assets/back-end') }}/svg/illustrations/sorry.svg"
                                alt="Image Description">
                            <p class="mb-0">{{ \App\CPU\translate('No data to show') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <!-- Page level custom scripts -->
    <script>
        $(document).on('click', '#viewPet', function() {
            debugger
            $('.loading-spinner').show();
            $('.petDet').hide();
            var id = $(this).val();
            var url = "/admin/pet-list-approval/view/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    console.log(response);
                    $('.petDet').show();
                    $('#id').val(id)
                    $('#petName').html(response.data[0].pet_name)
                    $('#petType').html(response.data[0].type)
                    $('#petBreed').html(response.data[0].breed)
                    $('#petGender').html(response.data[0].gender)
                    $('#petAge').html(response.data[0].age)
                    $('#petAgePeriod').html(response.data[0].age_period)
                    $('#petListingType').html(response.data[0].listing_type)
                    $('#petImg').attr('src', response.data[0].image1);
                    $('#petImg').show();
                    var approveHandler = function() {
                        change_status(response.data[0].id, 1);
                    };
                    var denyHandler = function() {
                        change_status(response.data[0].id, 0);
                    };
                    $('.apr').click(approveHandler);
                    $('.den').click(denyHandler);

                    $('.close').click(function() {
                        $('.apr').off('click', approveHandler);
                        $('.den').off('click', denyHandler);
                        $('#id').val("")
                        $('#petName').html("")
                        $('#petType').html("")
                        $('#petBreed').html("")
                        $('#petGender').html("")
                        $('#petAge').html("")
                        $('#petAgePeriod').html("")
                        $('#petListingType').html("")
                        $('#petImg').attr("src", "");
                    })
                    $('.loading-spinner').hide();
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr);
                    alert(xhr.status);
                    alert(thrownError);
                    $('.loading-spinner').hide();
                }
            });
        });

        function change_status(id, status) {
            debugger
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.pet-list-approval.change_status') }}",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function() {
                    toastr.success('{{ \App\CPU\translate('Pet status updated successfully') }}');
                    window.location.reload();
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr);
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }
    </script>
@endpush
