@extends('layouts.back-end.app')
@section('title', \App\CPU\translate('home_service_request'))
@push('css_or_js')
    <link href="{{ asset('public/assets/back-end') }}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="{{ asset('public/assets/back-end/css/tags-input.min.css') }}" rel="stylesheet">
    <link href="{{ asset('public/assets/select2/css/select2.min.css') }}" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="mb-3 d-flex justify-content-between">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="{{ asset('/public/assets/back-end/img/message.png') }}" alt="">
                {{ \App\CPU\translate('maintain_home_service_button') }}
            </h2>
        </div>
        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="pt-3">
                            @php($language = \App\Model\BusinessSetting::where('type', 'pnc_language')->first())
                            @php($language = $language->value ?? null)
                            @php($default_lang = 'en')

                            @php($default_lang = json_decode($language)[0])
                            <ul class="nav nav-tabs w-fit-content mb-4">
                                @foreach (json_decode($language) as $lang)
                                    <li class="nav-item">
                                        <a class="nav-link text-capitalize lang_link {{ $lang == $default_lang ? 'active' : '' }}"
                                            href="#"
                                            id="{{ $lang }}-link">{{ \App\CPU\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')' }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <form class="product-form" action="{{ route('admin.home-service.updateButton') }}"
                            method="POST"style="text-align: {{ Session::get('direction') === 'rtl' ? 'right' : 'left' }};"
                            enctype="multipart/form-data" id="product_form">
                            @csrf
                            @if ($button['button_image'] != null)
                                <img class="upload-img-view" id="viewer"
                                    onerror='this.src="{{ asset('public/assets/front-end/img/placeholder.png') }}"'
                                    src="{{ asset('storage/app/public/HomeServiceAddition') }}/{{ $button['button_image'] }}""
                                    alt="Home Servie Button Image" />
                            @endif
                            <div class="row">
                                <div class="col-md-8 form-group">
                                    <div class="mb-2">
                                        <label class="title-color">{{ \App\CPU\translate('Upload Button Image') }}</label>
                                        <span class="text-info">* ( {{ \App\CPU\translate('ratio') }} 1:1 )</span>
                                    </div>
                                    <div class="p-2 border border-dashed coba-area">
                                        <input type="file" accept="image/png, image/gif, image/jpeg" name="file[]">
                                    </div>
                                </div>
                            </div>
                            <div class="card-body row">
                                @foreach (json_decode($language) as $lang)
                                    <?php
                                    // dd($homeServiceBanner);
                                    if (count($button['translations'])) {
                                        $translate = [];
                                        foreach ($button['translations'] as $t) {
                                            if ($t->locale == $lang && $t->key == 'text') {
                                                $translate[$lang]['text'] = $t->value;
                                            }
                                        }
                                    }
                                    ?>
                                    <div class="{{ $lang != $default_lang ? 'd-none' : '' }} lang_form form-group pt-4 col-4"
                                        id="{{ $lang }}-form">
                                        <input type="hidden" name="lang[]" value="{{ $lang }}">
                                        <div class="">
                                            <label class="title-color">{{ \App\CPU\translate('text') }}
                                                ({{ strtoupper($lang) }})
                                            </label>
                                            </br>
                                            <input type="text"
                                                value="{{ $lang == $default_lang ? $button['text'] : $translate[$lang]['text'] ?? '' }}"
                                                class="form-control" name="text[]">
                                        </div>
                                    </div>
                                @endforeach
                                <div class="form-group pt-4 col-4">
                                    <label class="title-color" for="description">{{ \App\CPU\translate('text_color') }}
                                    </label>
                                    </br>
                                    <input type="color" value="{{ $button['text_color'] }}"
                                        class="form-control form-control_color" name="text_color">
                                </div>
                            </div>
                            <button type="submit"class="btn btn--primary mt-3">{{ \App\CPU\translate('Update') }}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('script')
    <script src="{{ asset('public/assets/back-end') }}/js/tags-input.min.js"></script>
    <script src="{{ asset('public/assets/back-end/js/spartan-multi-image-picker.js') }}"></script>
    <script>
        // debugger
        // $("#imgShowCase").html("");

        // $.each(selectedFiles, function(key, value){
        //     let imgPath = "{{ asset('/') }}"+value;

        //     var imagePreview = $('<img>')
        //     .attr('src', URL.createObjectURL(value))
        //     .attr('name', "image" + imageCount)
        //     .attr('onclick', "remove(this)")
        //     .attr('height', "180px")
        //     .addClass('image-thumbnail')
        //     .addClass('col-4');
        //     $("#imgShowCase").append(imagePreview);

        // });


        $(document).ready(function() {
            $('.upload-img-view').click(function() {
                var index = $(this).data('index');
                // Populate the modal content and show the modal based on the retrieved index
                // You can use `index` to identify the clicked image and update modal content accordingly
            });
        });

        function updateValidation(bool) {

            const requiredInput = document.getElementById('bannerUpdateImageInput');

            if (bool == 1) {
                requiredInput.setAttribute('required', 'required');
            } else {
                requiredInput.removeAttribute('required');
            }
        }
        $(".lang_link").click(function(e) {
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#" + lang + "-form").removeClass('d-none');
            if (lang == '{{ $default_lang }}') {
                $(".rest-part").removeClass('d-none');
            } else {
                $(".rest-part").addClass('d-none');
            }
        })
    </script>
    {{-- ck editor --}}
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '{{ Session::get('direction') }}',
        });
    </script>

    {{-- ck editor --}}
@endpush
