@extends('layouts.back-end.app')
@section('title', \App\CPU\translate('home_service_request'))
@push('css_or_js')
<link href="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3 d-flex justify-content-between">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="{{asset('/public/assets/back-end/img/message.png')}}" alt="">
                {{\App\CPU\translate('home_service_request')}}
                <span class="badge badge-soft-dark radius-50 fz-14 ml-1">{{ $home_service_requests->total() }}</span>
            </h2>
            <div>
                <a class="btn btn--primary" href="{{route('admin.home-service.maintain-home-service',[$homeServiceBanner['id']])}}">Maintain Home Service Banner</a>
                <a class="btn btn--primary" href="{{route('admin.home-service.maintain-home-service-button',[$homeServiceBanner['id']])}}">Maintain Home Service button</a>
            </div>
        </div>
    
    <div class="row mt-20">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row justify-content-between align-items-center flex-grow-1">
                        <div class="col-12">
                                <!-- Search -->
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="row">
                                        <div class="col-4">
                                            <div class="mr-2 input-group input-group-merge input-group-custom">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text">
                                                        <i class="tio-search"></i>
                                                    </div>
                                                </div>
                                                <!-- Edited by dSMART -->
                                                <input id="datatableSearch_" type="search" name="search" class="form-control"
                                                placeholder="{{\App\CPU\translate('Search_by_Customer_Name')}}"
                                                    aria-label="Search orders">
                                            </div>
                                        </div>
                                        <div class="col-3 ">
                                            <div class="form-floating">
                                                <input type="date" name="from_date" id="from_date"
                                                    class="form-control">
                                                <label>{{\App\CPU\translate('Start_Date')}}</label>
                                            </div>
                                        </div>
                                        <div class="col-3 ">
                                            <div class="form-floating">
                                                <input type="date"  name="to_date" id="to_date" class="form-control">
                                                <label>{{\App\CPU\translate('End_Date')}}</label>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <button type="submit"
                                                class="btn btn--primary">search
                                            </button>
                                        </div>
                                    </div>
                                        
                                </form>
                                <!-- End Search -->
                        </div>
                    </div>
                </div>

                <div class="table-responsive">
                        <table id="datatable"
                               style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};"
                               class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('Customer_Name')}}</th>
                                <th>{{\App\CPU\translate('Contact_Info')}}</th>
                                <th>{{\App\CPU\translate('Address')}}</th>
                                <th>{{\App\CPU\translate('Request')}}</th>
                                <th>{{\App\CPU\translate('Status')}}</th>
                                <th>{{\App\CPU\translate('Date')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php
                                $serialNumber = 1;
                            @endphp
                            @foreach($home_service_requests as $k=>$home_service)
                                <tr>
                                    <td>{{$serialNumber}}</td>
                                    <td>{{$home_service['first_name']}} {{$home_service['last_name']}}</td>
                                    <td>{{$home_service['contact_info']}}</td>
                                    <td class="text-wrap">
                                        <a href="https://www.google.com/maps/place/{{$home_service['address']}}"target="_blank">{{$home_service['address']}}</a>
                                    </td>
                                    <td class="text-wrap">{{$home_service['request']}}</td>
                                    <td class="text-wrap">
                                    @if($home_service['status'] != null)
                                        @if($home_service['status'] == 'Completed')
                                            <button type="button" class="btn text-success bg-soft-success font-weight-bold fz-12" id="maintainStatus" data-toggle="modal" value="{{$home_service->id}}"data-target="#statusModal"><i class="tio tio-edit" title="Edit Status"></i><span>{{$home_service['status']}}</span></button>
                                        @elseif($home_service['status'] == 'Rejected')
                                            <button type="button" class="btn text-danger bg-soft-danger font-weight-bold fz-12" id="maintainStatus" data-toggle="modal" value="{{$home_service->id}}"data-target="#statusModal"><i class="tio tio-edit" title="Edit Status"></i><span>{{$home_service['status']}}</span></button>
                                        @elseif($home_service['status'] == 'Open')
                                            <button type="button" class="btn text-warning bg-soft-warning font-weight-bold fz-12" id="maintainStatus" data-toggle="modal" value="{{$home_service->id}}"data-target="#statusModal"><i class="tio tio-edit" title="Edit Status"></i><span>{{$home_service['status']}}</span></button>
                                        @else
                                            <button type="button" class="btn text-info bg-soft-info font-weight-bold fz-12" id="maintainStatus" data-toggle="modal" value="{{$home_service->id}}"data-target="#statusModal"><i class="tio tio-edit" title="Add Status"></i><span>Pending</span></button>
                                        @endif
                                    @else
                                        <button type="button" class="btn text-info bg-soft-info font-weight-bold fz-12" id="maintainStatus" data-toggle="modal" value="{{$home_service->id}}"data-target="#statusModal"><i class="tio tio-edit" title="Add Status"></i><span>Pending</span></button>
                                    @endif
                                    </td>
                                    <td>
                                        <div>{{date('d M Y',strtotime($home_service['created_at']))}},</div>
                                        <div>{{ date("h:i A",strtotime($home_service['created_at'])) }}</div>
                                    </td>
                                    
                                </tr>
                                @php
                                    $serialNumber++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="table-responsive mt-4">
                    <div class="px-4 d-flex justify-content-lg-end">
                        <!-- Pagination -->
                        {{$home_service_requests->links()}}
                    </div>
                </div>
                @if(count($home_service_requests)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                @endif

            </div>
        </div>
    </div>
    </div>

    <!-- Status Modal -->
    <div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">{{\App\CPU\translate('Update_Status')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <div class="card mb-3">
                            <div class="card-body">
                                <table class="table table-user-information table-borderless mb-0">
                                    <tbody>
                                        <tr>
                                            <td class="font-weight-bold ml-5">{{\App\CPU\translate('customer_name')}}:</td>
                                            <input type="hidden" id="id" value="" class="d-none"></input>
                                            <td class="ml-5" id="customerName"></td>
                                        </tr>
                                        <tr>
                                            <td class="font-weight-bold ml-5">{{\App\CPU\translate('contact_info')}}:</td>
                                            <td class="ml-5" id="contactInfo"></td>
                                        </tr>
                                        <tr>
                                            <td class="font-weight-bold ml-5">{{\App\CPU\translate('address')}}:</td>
                                            <td class="ml-5" id="address"></td>
                                        </tr>
                                        <tr>
                                            <td class="font-weight-bold ml-5">{{\App\CPU\translate('request')}}:</td>
                                            <td class="ml-5" id="request"></td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                            </div>
                            <div class="card-footer">
                                <form action="{{route('admin.home-service.update-status')}}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="container">
                                        <input type="hidden" name="id" id="homeServiceId" value="" class="form-control">
                                        <select class="js-example-basic-multiple form-control col-md-12 mb-2" name="status" id="status">
                                            <option value="" selected disabled>--Select Status--</option>
                                            @foreach (\App\CPU\Helpers::serviceStatus() as $x)
                                            <option value="{{ $x }}" {{$x == $home_service_requests['status'] ? "selected"  : ""}}>
                                                {{ $x }}</option>
                                            @endforeach
                                        </select>
                                        <textarea name="comment" value="" rows="5" id="comment" class="form-control col-md-12 mb-2" placeholder="Write comment here"></textarea>
                                        <div class="d-flex justify-content-between">
                                            <div></div>
                                            <input type="submit" class="btn btn-success apr" value="Save">
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
@endsection

@push('script')

<script>

        $(document).on('click', '#maintainStatus', function () {
            var id = $(this).val();
            var url = "/admin/home-service/view/" + id;
            $.ajax({
              url: url,
              method: 'GET',
              success: function (response) {
                console.log(response);
                $('#homeServiceId').val(id)
                $('#customerName').html(response.data[0].first_name) 
                $('#contactInfo').html(response.data[0].contact_info)
                $('#address').html(response.data[0].address)
                $('#request').html(response.data[0].request)
                $('#comment').html(response.data[0].comment)
                $('#status').val(response.data[0].status)
              },
              error: function (xhr, ajaxOptions, thrownError) {
                    console.log(xhr);
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        });
        function mbimagereadURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileUpload").change(function () {
            mbimagereadURL(this);
        });
    </script>
    <script src="{{ asset('public/assets/back-end') }}/js/tags-input.min.js"></script>
    <script src="{{ asset('public/assets/back-end/js/spartan-multi-image-picker.js') }}"></script>
    {{-- ck editor --}}
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="{{ asset('/') }}vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '{{ Session::get('direction') }}',
        });
    </script>

{{-- ck editor --}}

@endpush