@extends('layouts.back-end.app')
{{-- @section('title', 'Customer') --}}
@section('title', \App\CPU\translate('Customer Details'))

@push('css_or_js')
@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="d-print-none pb-2">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">

                    <!-- Page Title -->
                    <div class="mb-3">
                        <h2 class="h1 mb-0 text-capitalize d-flex gap-2">
                            <img width="20" src="{{ asset('/public/assets/back-end/img/customer.png') }}" alt="">
                            {{ \App\CPU\translate('customer_details') }}
                        </h2>
                    </div>
                    <!-- End Page Title -->
                    <div class="d-sm-flex align-items-sm-center">
                        <h3 class="page-header-title">{{ \App\CPU\translate('Customer ID') }} #{{ $customer['id'] }}</h3>
                        <span class="{{ Session::get('direction') === 'rtl' ? 'mr-2 mr-sm-3' : 'ml-2 ml-sm-3' }}">
                            <i class="tio-date-range">
                            </i> {{ \App\CPU\translate('Joined At') }} :
                            {{ date('d M Y H:i:s', strtotime($customer['created_at'])) }}
                        </span>
                    </div>

                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home"
                            role="tab" aria-controls="nav-home"
                            aria-selected="true">{{ \App\CPU\translate('Order') }}</a>
                        <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile"
                            role="tab" aria-controls="nav-profile"
                            aria-selected="false">{{ \App\CPU\translate('Pets') }}</a>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                <div class="row" id="printableArea">
                    <div class="col-lg-8 mb-3 mb-lg-0">
                        <div class="card">
                            <div class="p-3 d-flex justify-content-between">
                                {{-- <div class="row justify-content-start">
                                    <div class="col-auto">
                                        <form action="{{ url()->current() }}" method="GET">
                                            <!-- Search -->
                                            <div class="col-5">
                                                <input type="hidden" name="unpaid" value="unpaid">
                                            </div>
                                            <div class="col-2">
                                                <button type="submit"
                                                    class="btn btn--primary">{{ \App\CPU\translate('outstanding_invoices') }}</button>
                                            </div>
                                            <!-- End Search -->
                                        </form>
                                    </div>
                                </div> --}}
                                <div>
                                    <div>
                                        <form action="{{ url()->current() }}" method="GET">
                                            <!-- Search -->
                                            <div class="row">
                                                <div class="col-5">
                                                    <input id="datatableSearch_" type="search" name="search"
                                                        class="form-control"
                                                        placeholder="{{ \App\CPU\translate('Search orders') }}"
                                                        aria-label="Search orders" value="{{ $search }}">
                                                </div>
                                                <div class="col-5">
                                                    <select name="filterByDebt" class="form-control">
                                                        <option value="">{{ \App\CPU\translate('All') }}</option>
                                                        <option
                                                            value="unpaid"{{ $request->input('filterByDebt') == 'unpaid' ? 'selected' : '' }}>
                                                            {{ \App\CPU\translate('outstanding_invoices') }}</option>
                                                        <option value="paid"
                                                            {{ $request->input('filterByDebt') == 'paid' ? 'selected' : '' }}>
                                                            {{ \App\CPU\translate('cleared_invoices') }}</option>
                                                    </select>
                                                </div>
                                                <div class="col-2">
                                                    <button type="submit"
                                                        class="btn btn--primary">{{ \App\CPU\translate('search') }}</button>
                                                </div>
                                            </div>
                                            <!-- End Search -->
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                    <thead class="thead-light thead-50 text-capitalize">
                                        <tr>
                                            <th>{{ \App\CPU\translate('sl') }}</th>
                                            <th>{{ \App\CPU\translate('Order ID') }}</th>
                                            <th>{{ \App\CPU\translate('Total') }}</th>
                                            <th>{{ \App\CPU\translate('Order') }} {{ \App\CPU\translate('Status') }}</th>
                                            <th class="text-center">{{ \App\CPU\translate('Action') }}</th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        @foreach ($orders as $key => $order)
                                            <tr>
                                                <td>{{ $orders->firstItem() + $key }}</td>
                                                <td>
                                                    <a href="{{ route('admin.orders.details', ['id' => $order['id']]) }}"
                                                        class="title-color hover-c1">{{ $order['id'] }}</a>
                                                </td>
                                                <td> {{ \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order['order_amount'])) }}
                                                </td>
                                                <td>
                                                    @if ($order->payment_status == 'paid')
                                                        <span class="badge text-success fz-12 px-0">
                                                            {{ \App\CPU\translate('paid') }}
                                                        </span>
                                                    @else
                                                        <span class="badge text-danger fz-12 px-0">
                                                            {{ \App\CPU\translate('unpaid') }}
                                                        </span>
                                                    @endif
                                                </td>

                                                <td>
                                                    <div class="d-flex justify-content-center gap-10">
                                                        <a class="btn btn-outline--primary btn-sm edit square-btn"
                                                            title="{{ \App\CPU\translate('View') }}"
                                                            href="{{ route('admin.orders.details', ['id' => $order['id']]) }}"><i
                                                                class="tio-invisible"></i> </a>
                                                        <a class="btn-generate-invoice btn btn-outline-info btn-sm square-btn"
                                                            title="{{ \App\CPU\translate('Invoice') }}" target="_blank"
                                                            href="{{ route('admin.orders.generate-invoice', [$order['id']]) }}"><i
                                                                class="tio-download"></i> </a>
                                                        @if ($order->payment_status == 'paid')
                                                        <button disabled class="btn btn-secondary btn-outline-secondary btn-sm square-btn"
                                                            id="{{ $order['id'] }}"
                                                            title="{{ \App\CPU\translate('Paid') }}"><i
                                                                class="tio-checkmark-circle"></i> </button>
                                                        @else
                                                        <a class="btn btn-outline-info btn-sm square-btn markPaid"
                                                            id="{{ $order['id'] }}"
                                                            title="{{ \App\CPU\translate('Mark_as_Paid') }}"><i
                                                                class="tio-checkmark-circle"></i> </a>
                                                        @endif

                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                @if (count($orders) == 0)
                                    <div class="text-center p-4">
                                        <img class="mb-3 w-160"
                                            src="{{ asset('public/assets/back-end') }}/svg/illustrations/sorry.svg"
                                            alt="Image Description">
                                        <p class="mb-0">{{ \App\CPU\translate('No_data_to_show') }}</p>
                                    </div>
                                @endif
                                <!-- Footer -->
                                <div class="card-footer">
                                    <!-- Pagination -->
                                    {!! $orders->links() !!}
                                    <!-- End Pagination -->
                                </div>
                                <!-- End Footer -->
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <!-- Card -->
                        <div class="card">
                            @if ($customer)
                                <div class="card-body">
                                    <h4 class="mb-4 d-flex align-items-center gap-2">
                                        <img src="{{ asset('/public/assets/back-end/img/seller-information.png') }}"
                                            alt="">
                                        {{ \App\CPU\translate('Customer') }}
                                    </h4>

                                    <div class="media">
                                        <div class="mr-3">
                                            <img class="avatar rounded-circle avatar-70"
                                                onerror="this.src='{{ asset('public/assets/front-end/img/image-place-holder.png') }}'"
                                                src="{{ asset('storage/app/public/profile/' . $customer->image ?? '') }}"
                                                alt="Image">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <span
                                                class="title-color hover-c1"><strong>{{ $customer['f_name'] . ' ' . $customer['l_name'] }}</strong></span>
                                            <span class="title-color">
                                                <strong>{{ \App\Model\Order::where('customer_id', $customer['id'])->count() }}
                                                </strong>{{ \App\CPU\translate('orders') }}
                                            </span>
                                            <span class="title-color">
                                                <strong>{{ \App\Model\PetApproval::where('customerid', $customer['id'])->count() }}
                                                </strong>{{ \App\CPU\translate('pets') }}
                                            </span>
                                            <span class="title-color"><strong>{{ $customer['phone'] }}</strong></span>
                                            <span class="title-color">{{ $customer['email'] }}</span>
                                        </div>
                                        <div class="media-body text-right">
                                            {{-- <i class="tio-chevron-right text-body"></i> --}}
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- End Body -->
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                <div class="row" id="printableArea">
                    <div class="col-lg-8 mb-3 mb-lg-0">
                        <div class="card">
                            <div class="p-3">
                                <div class="row justify-content-end">
                                    <div class="col-auto">
                                        <form action="{{ url()->current() }}" method="GET">
                                            <!-- Search -->
                                            <!-- <div class="input-group input-group-merge input-group-custom">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text">
                                                                <i class="tio-search"></i>
                                                            </div>
                                                        </div>
                                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                                            placeholder="{{ \App\CPU\translate('Search orders') }}" aria-label="Search orders" value="{{ $search }}"
                                                            required>
                                                        <button type="submit" class="btn btn--primary">{{ \App\CPU\translate('search') }}</button>
                                                    </div> -->
                                            <!-- End Search -->
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                    <thead class="thead-light thead-50 text-capitalize">
                                        <tr>
                                            <th>{{ \App\CPU\translate('sl') }}</th>
                                            <th>{{ \App\CPU\translate('Pet ID') }}</th>
                                            <th>{{ \App\CPU\translate('Name') }}</th>
                                            <th>{{ \App\CPU\translate('Type') }}</th>
                                            <th>{{ \App\CPU\translate('Gender') }}</th>
                                            <th>{{ \App\CPU\translate('Age') }}</th>
                                            <th>{{ \App\CPU\translate('Listing Type') }}</th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        @php
                                            $serialNumber = 1;
                                        @endphp
                                        @foreach ($pet as $item)
                                            <tr>
                                                <td>{{ $serialNumber }}</td>
                                                <td>{{ $item['id'] }}</td>
                                                <td>{{ $item['pet_name'] }}</td>
                                                <td>{{ $item['type'] }}</td>
                                                <td>{{ $item['gender'] }}</td>
                                                <td>{{ $item['age'] }}</td>
                                                <td>{{ $item['listing_type'] }}</td>
                                            </tr>
                                            @php
                                                $serialNumber++;
                                            @endphp
                                        @endforeach
                                    </tbody>
                                </table>
                                @if (count($pet) == 0)
                                    <div class="text-center p-4">
                                        <img class="mb-3 w-160"
                                            src="{{ asset('public/assets/back-end') }}/svg/illustrations/sorry.svg"
                                            alt="Image Description">
                                        <p class="mb-0">{{ \App\CPU\translate('No_data_to_show') }}</p>
                                    </div>
                                @endif
                                <!-- Footer -->
                                <div class="card-footer">
                                    <!-- Pagination -->
                                    {!! $pet->links() !!}
                                    <!-- End Pagination -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <!-- Card -->
                        <div class="card">
                            @if ($customer)
                                <div class="card-body">
                                    <h4 class="mb-4 d-flex align-items-center gap-2">
                                        <img src="{{ asset('/public/assets/back-end/img/seller-information.png') }}"
                                            alt="">
                                        {{ \App\CPU\translate('Customer') }}
                                    </h4>

                                    <div class="media">
                                        <div class="mr-3">
                                            <img class="avatar rounded-circle avatar-70"
                                                onerror="this.src='{{ asset('public/assets/front-end/img/image-place-holder.png') }}'"
                                                src="{{ asset('storage/app/public/profile/' . $customer->image ?? '') }}"
                                                alt="Image">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <span
                                                class="title-color hover-c1"><strong>{{ $customer['f_name'] . ' ' . $customer['l_name'] }}</strong></span>
                                            <span class="title-color">
                                                <strong>{{ \App\Model\Order::where('customer_id', $customer['id'])->count() }}
                                                </strong>{{ \App\CPU\translate('orders') }}
                                            </span>
                                            <span class="title-color">
                                                <strong>{{ \App\Model\PetApproval::where('customerid', $customer['id'])->count() }}
                                                </strong>{{ \App\CPU\translate('pets') }}
                                            </span>
                                            <span class="title-color"><strong>{{ $customer['phone'] }}</strong></span>
                                            <span class="title-color">{{ $customer['email'] }}</span>
                                        </div>
                                        <div class="media-body text-right">
                                            {{-- <i class="tio-chevron-right text-body"></i> --}}
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <!-- End Body -->
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
        </div>





        <!-- End Row -->
    </div>
@endsection
@push('script')
    <script>
        $(document).on('click', '.markPaid', function() {
            var id = $(this).attr("id");
            Swal.fire({
                title: "{{ \App\CPU\translate('Are_you_sure_to_mark_paid') }}?",
                text: "{{ \App\CPU\translate('You_will_not_be_able_to_revert_this') }}!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{ \App\CPU\translate('Yes') }}, {{ \App\CPU\translate('mark_it') }}!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ url('admin/customer/order-status-update') }}",
                        method: 'POST',
                        data: {
                            id: id
                        },
                        success: function(response) {
                            document.querySelector('.btn-generate-invoice').click();
                            toastr.success('{{ \App\CPU\translate('Order_marked_as_a_paid ') }}');
                            console.log(response);
                            $('#data-' + id).hide();
                            window.location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                            toastr.error('{{ \App\CPU\translate('An_error_occurred ') }}');
                        }
                    });
                }
            });
        });

        function generateInvoice(id) {
            return new Promise(function(resolve, reject) {
                try {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{ url('admin/orders/generate-invoice/') }}/" + id,
                        method: 'GET',
                        success: function(invoiceResponse) {
                            resolve(invoiceResponse);
                        },
                        error: function(invoiceXhr, invoiceStatus, invoiceError) {
                            reject(invoiceXhr);
                        }
                    });
                } catch (error) {
                    console.error(error)
                }
            });
        }
    </script>
@endpush

@push('script_2')
@endpush
