@extends('layouts.back-end.app')

@section('title', \App\CPU\translate('Social_Links'))

@push('css_or_js')

@endpush

@section('content')
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="{{asset('/public/assets/back-end/img/business-setup.png')}}" alt="">
                {{\App\CPU\translate('Business_Setup')}}
            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        @include('admin-views.business-settings.business-setup-inline-menu')

    <!-- End Inlile Menu -->
        <form action="{{ route('admin.business-settings.social-links-update') }}" method="post"
              enctype="multipart/form-data" id="update-settings">
            @csrf
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                            <div class="form-group">
                                <label class="input-label" for="maximum_otp_hit">{{translate("Whatsapp")}}
                                </label>
                                <input type="text" value="{{$whatsapp->path}}"
                                       name="whatsapp_path" class="form-control" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4">
                            <div class="form-group">
                                <label class="input-label" for="otp_resend_time">{{translate('Facebook')}}
                                </label>
                                <input type="text" value="{{$facebook->path}}"
                                       name="facebook_path" class="form-control" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4">
                            <div class="form-group">
                                <label class="input-label" for="temporary_block_time">{{translate('Instagram')}}
                                </label>
                                <input type="text" value="{{$instagram->path}}"
                                       name="instagram_path" class="form-control" placeholder="" required>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-4">
                            <div class="form-group">
                                <label class="input-label" for="maximum_otp_hit">{{translate('Web')}}
                                </label>
                                <input type="text" value="{{$web->path}}"
                                       name="web_path" class="form-control" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4">
                            <div class="form-group">
                                <label class="input-label" for="temporary_block_time">{{translate('Snapchat')}}
                                </label>
                                <input type="text" value="{{$snapchat->path}}"
                                       name="snapchat_path" class="form-control" placeholder="" required>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex gap-3 justify-content-end">
                        <button type="submit" class="btn btn--primary px-4">
                            {{translate('save')}}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>

@endsection
