
<!-- Edited by dSMART -->
@extends('layouts.back-end.app')

@section('title', \App\CPU\translate('blogs'))

@push('css_or_js')
<link href="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="{{asset('/public/assets/back-end/img/message.png')}}" alt="">
                {{\App\CPU\translate('blogs')}}
                <span class="badge badge-soft-dark radius-50 fz-14 ml-1">{{ $blog->total() }}</span>
            </h2>
        </div>
    <div class="row mt-20">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row justify-content-between align-items-center flex-grow-1">
                    <!-- <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                                <h5 class="d-flex gap-2 align-items-center">
                                    {{\App\CPU\translate('Blogs')}} {{\App\CPU\translate('Table')}} 
                                    <span
                                    
                                        class="badge badge-soft-dark radius-50 fz-12"></span>
                                </h5>
                    </div> -->
                        <div class="col-sm-8 col-md-6 col-lg-4 mb-2 mb-sm-0">
                            <!-- Edited by dSMART -->
                                <!-- Search -->
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <!-- Edited by dSMART -->
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                               placeholder="{{\App\CPU\translate('Search_by_Title')}}"
                                               aria-label="Search orders" value="{{ $search }}">

                                               <!-- Edited by dSMART -->
                                            <input type="hidden" name="status">
                                            <button type="submit"
                                                class="btn btn--primary">{{\App\CPU\translate('search')}}
                                            </button>
                                    </div>
                                </form>
                                <!-- End Search -->
                        </div>

                        <!-- Edited by dSMART -->
                        <div class="mt-3 mt-lg-0">
                            <!-- href="{{route('admin.product.add-new')}}" -->
                                <a  class="btn btn--primary" href="{{route('admin.blog.add-new')}}">
                                    <i class="tio-add"></i>
                                    <span class="text">{{\App\CPU\translate('Add_New_Blog')}}</span>
                                </a>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                        <table id="datatable"
                               style="text-align: {{Session::get('direction') === 'rtl' ? 'right' : 'left'}};"
                               class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th>{{\App\CPU\translate('SL')}}</th>
                                <th>{{\App\CPU\translate('Image')}}</th>
                                <th>{{\App\CPU\translate('Title')}}</th>
                                <th>{{\App\CPU\translate('Date')}}</th>
                                <th class="text-center">{{\App\CPU\translate('Active_Status')}}</th>
                                <th>{{\App\CPU\translate('Action')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($blog as $k=>$blog_post)
                                <tr>
                                    <td>{{$k + 1}}</td>
                                    <td><img class="rounded" width="100" onerror="this.src='{{asset('public/assets/back-end/img/160x160/img2.jpg')}}'" src="{{asset('storage/app/public/blog')}}/{{$blog_post['img']}}" alt=""></td>
                                    <td>{{$blog_post['title']}}</td>
                                    <td>
                                        <div>{{date('d M Y',strtotime($blog_post['created_at']))}},</div>
                                        <div>{{ date("h:i A",strtotime($blog_post['created_at'])) }}</div>
                                    </td>
                                    <td>
                                        <label class="mx-auto text-center switcher">
                                            <input class="switcher_input" type="checkbox"
                                            onclick="change_status('{{$blog_post['id']}}')" {{$blog_post->isActive == 1 ? 'Checked':''}}>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-10">
                                            <a class="btn btn-outline--primary btn-sm cursor-pointer edit"
                                               title="{{ \App\CPU\translate('Edit')}}"
                                               href="{{route('admin.blog.edit',[$blog_post['id']])}}"
                                               >
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="btn btn-outline-danger btn-sm cursor-pointer delete"
                                               title="{{ \App\CPU\translate('Delete')}}"
                                               id="{{$blog_post['id']}}"
                                               >
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                    </td>
                                        <!-- <td class="text-wrap">{{$blog_post['isActive']}}</td> -->
                                    
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                </div>
                <div class="table-responsive mt-4">
                    <div class="px-4 d-flex justify-content-lg-end">
                        <!-- Pagination -->
                        {{$blog->links()}}
                    </div>
                </div>
                @if(count($blog)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0">{{\App\CPU\translate('No data to show')}}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
    </div>
@endsection

@push('script')
    <!-- Page level custom scripts -->
    <script>

        function change_status(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{route('admin.blog.update-status')}}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function () {
                    toastr.success('{{\App\CPU\translate('blog status updated successfully')}}');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: "{{\App\CPU\translate('Are_you_sure_delete_this_blog')}}?",
                text: "{{\App\CPU\translate('You_will_not_be_able_to_revert_this')}}!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{\App\CPU\translate('Yes')}}, {{\App\CPU\translate('delete_it')}}!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('admin.blog.delete')}}",
                        method: 'POST',
                        data: {id: id},
                        success: function (response) {
                            console.log(response);
                            window.location.reload();
                            toastr.success('{{\App\CPU\translate('Blog_deleted_successfully')}}');
                            $('#data-' + id).hide();
                        }
                    });
                }
            })
        });
    </script>

@endpush