<?php

namespace App\Model;

use App\User;
use App\Model\MedicalHistory;
use Illuminate\Database\Eloquent\Model;

class ProductPackSizes extends Model
{
    protected $casts = [
        'id' => 'integer',
        'product_id' => 'integer',
        'pack_name' => 'string',
        'unit_price' => 'integer',
        'purchase_price' => 'integer',
        'current_stock' => 'integer',
        'expiry_date' => 'datetime',
        'shipping_cost' => 'integer',
        'tax' => 'integer',
        'tax_type' => 'string',
        'tax_model' => 'string',
        'discount' => 'integer',
        'discount_type' => 'string',
        'multiply_qty' => 'integer',
        'isActive' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',

    ];

    public function order_details()
    {
        return $this->hasMany(OrderDetail::class, 'product_pack_id');
    }
    protected $table = 'product_pack_sizes';
}
