<?php

namespace App\Model;

use App\User;
use App\Model\MedicalHistory;
use Illuminate\Database\Eloquent\Model;

class ProductPackQty extends Model
{
    public $timestamps = false;
    protected $casts = [
        'id' => 'integer',
        'pack_id' => 'integer',
        'product_id' => 'integer',
        'variant_name' => 'string',
        'quantity' => 'integer',

    ];
    protected $table = 'product_pack_quantity';

    public function pack()
    {
        return $this->belongsTo(Product::class, 'pack_id');
    }
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
