<?php

namespace App\Model;

use App\User;
use App\Model\PetApproval;
use Illuminate\Database\Eloquent\Model;

class PetTransferLog extends Model
{
    protected $casts = [
        'id' => 'integer',
        'from_customer_id' => 'integer',
        'to_customer_id' => 'integer',
        'pet_id' => 'integer',
        
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    protected $table = 'pet_transfer_log';

    public function from_customer()
    {
        return $this->belongsTo(User::class, 'from_customer_id', 'id')->select('id','f_name');
    }
    public function to_customer()
    {
        return $this->belongsTo(User::class, 'to_customer_id', 'id')->select('id','f_name');
    }
    public function pet(){
        return $this->belongsTo(PetApproval::class, 'pet_id', 'id')->select('id','pet_name');
    }
}
