<?php

namespace App\Model;

use App\User;
use App\Model\MedicalHistory;
use Illuminate\Database\Eloquent\Model;

class PetApproval extends Model
{
    protected $casts = [
        'id' => 'integer',
        'pet_name' => 'string',
        'type' => 'string',
        'gender' => 'string',
        'age' => 'string',
        'age_period' => 'string',
        'breed' => 'string',
        'city' => 'string',
        'description' => 'string',
        'listing_type' => 'string',
        'customerid' => 'integer',
        'microchip_id' => 'string',
        'is_approved' => 'integer',
        'image1' => 'string',
        'image2' => 'string',
        'image3' => 'string',

        // new feild
        'expiry' => 'integer',
        'owner_name' => 'string',
        'phone' => 'string',
        
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    protected $table = 'pet';

    public function customer()
    {
        return $this->belongsTo(User::class, 'customerid', 'id');
    }
    public function medicalHistory(){
        return $this->hasMany(MedicalHistory::class, 'pet_id');
    }
}
