<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use App\Model\Product;

class Notification extends Model
{
    protected $casts = [
        'status'     => 'integer',
        'product_id' => 'integer',
        'slug' => 'string',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function scopeActive($query)
    {
        return $query->where('status', '=', 1);
    }
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
