<?php

namespace App\Model;

use App\Model\PetApproval;
use Illuminate\Database\Eloquent\Model;

class MedicalHistory extends Model
{
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'type' => 'string',
        'date ' => 'datetime',
        'next_due_in ' => 'integer',
        'notes ' => 'string',
        'pet_id' => 'integer',
        'period' => 'string',
        // new feilds
        'tempurature' => 'string',
        'weight' => 'string',
        'symptoms' => 'string',
        'diagnosis' => 'string',
        'doctor' => 'string',
        'place' => 'string',
        'result' => 'string',
        'images' => 'string',
        'video' => 'string',
        'document' => 'string',
        'drug' => 'string',
        'test' => 'string',
        'treatment' => 'string',

        
        'appointment_date' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    protected $table = 'medical_history';

    public function pet()
    {
        return $this->belongsTo(PetApproval::class, 'pet_id', 'id');
        
    }
}

