<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use App\CPU\Helpers;

class HomeServiceBanner extends Model
{
    protected $casts = [
        'id' => 'integer',
        'image1' => 'string',
        'image2' => 'string',
        'image3' => 'string',
        'image4' => 'string',
        'image5' => 'string',
        'description'=>'string',
    ];
    public $timestamps = false;
    protected $table = 'home_service_content';

    public function translations()
    {
        return $this->morphMany('App\Model\Translation', 'translationable');
    }

    public function getDescriptionAttribute($description)
    {
        if (strpos(url()->current(), '/admin') || strpos(url()->current(), '/seller')) {
            return $description;
        }
        return $this->translations[0]->value ?? $description;
    }
    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope('translate', function (Builder $builder) {
            $builder->with([
                'translations' => function ($query) {
                    if (strpos(url()->current(), '/api')) {
                        return $query->where('locale', App::getLocale());
                    } else {
                        return $query->where('locale', Helpers::default_lang());
                    }
                },
            ]);
        });
    }
}
