<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use App\CPU\Helpers;

class HomeServiceAddition extends Model
{
    protected $casts = [
        'id' => 'integer',
        'button_image' => 'string',
        'text ' => 'string',
        'text_color ' => 'string',
    ];
    public $timestamps = false;
    protected $table = 'home_service_configration';

    public function translations()
    {
        return $this->morphMany('App\Model\Translation', 'translationable');
    }
    public function getTextAttribute($text)
    {
        if (strpos(url()->current(), '/admin') || strpos(url()->current(), '/seller')) {
            return $text;
        }
        return $this->translations[0]->value ?? $text;
    }

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope('translate', function (Builder $builder) {
            $builder->with([
                'translations' => function ($query) {
                    if (strpos(url()->current(), '/api')) {
                        return $query->where('locale', App::getLocale());
                    } else {
                        return $query->where('locale', Helpers::default_lang());
                    }
                },
            ]);
        });
    }
}
