<?php

namespace App\Model;

use App\CPU\Helpers;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use App\Model\Tag;
use App\Model\Notification;

class Blog extends Model
{
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'description' => 'string',
        'img' => 'string',
        'isActive' => 'integer',

        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    protected $table = 'blog';

    public function translations()
    {
        return $this->morphMany('App\Model\Translation', 'translationable');
    }

    public function getTitleAttribute($title)
    {
        if (strpos(url()->current(), '/admin') || strpos(url()->current(), '/seller')) {
            return $title;
        }
        return $this->translations[0]->value ?? $title;
    }

    public function getDescriptionAttribute($description)
    {
        if (strpos(url()->current(), '/admin') || strpos(url()->current(), '/seller')) {
            return $description;
        }
        return $this->translations[1]->value ?? $description;
    }

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope('translate', function (Builder $builder) {
            $builder->with([
                'translations' => function ($query) {
                    if (strpos(url()->current(), '/api')) {
                        return $query->where('locale', App::getLocale());
                    } else {
                        return $query->where('locale', Helpers::default_lang());
                    }
                },
            ]);
        });
    }
}
