<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Storage;

class StoragePathRewrite
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Check if the request is for a file in /storage/app/public
        $originalUrl = $request->getRequestUri();

        if (strpos($originalUrl, '/storage/app/public/') !== false) {
            // Rewrite the URL by removing /app/public
            $correctedUrl = str_replace('/storage/app/public/', '/storage/', $originalUrl);

            // Redirect to the corrected URL
            return redirect($correctedUrl);
        }

        return $next($request);
    }
}

