<?php
namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use App\Model\MedicalHistory;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\CPU\ImageManager;
use Carbon\Carbon;


class PetsMedicalHistoryController extends Controller
{

    public function get_history_byPetId(Request $req)
    {

        $validator = Validator::make($req->all(), [
            'pet_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = MedicalHistory::where('pet_id', $req->get('pet_id'))->latest()->get();

        foreach ($pets as $value) {
            if ($value->images != '' && $value->images != null) {

                $res = "";
                $images = explode('>|<', $value->images);
                foreach ($images as $image) {
                    $res .= asset('storage/app/public/MedicalHistory') . '/' . $image . ">|<";
                }
                $value["images"] = rtrim($res, '>|<');
            }



            // videos

            if ($value->video != '' && $value->video != null) {
                $vid = "";
                $videos = explode('>|<', $value->video);
                foreach ($videos as $video) {
                    $vid .= asset('storage/app/public/MedicalHistory') . '/' . $video . ">|<";
                }
                $value["video"] = rtrim($vid, '>|<');
            }

            // Documents
            if ($value->document != '' && $value->document != null) {
                $doc = "";
                $documents = explode('>|<', $value->document);
                foreach ($documents as $document) {
                    $doc .= asset('storage/app/public/MedicalHistory') . '/' . $document . ">|<";
                }
                $value["document"] = rtrim($doc, '>|<');
            }
        }


        return response()->json($pets, 200);
    }

    public function getPetsWithHistory(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'customer_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }
        $pets = PetApproval::where('customerid', $req->get('customer_id'))->get();
        $petIds = $pets->pluck('id');

        $date = Carbon::now();

        $history = MedicalHistory::with('pet')->whereIn('pet_id', $petIds)->whereDate('appointment_date','>', $date->toDateString())->get();
        
        foreach ($history as $value) {
            if ($value->images != '' && $value->images != null) {

                $res = "";
                $images = explode('>|<', $value->images);
                foreach ($images as $image) {
                    $res .= asset('storage/app/public/MedicalHistory') . '/' . $image . ">|<";
                }
                $value["images"] = rtrim($res, '>|<');
            }



            // videos

            if ($value->video != '' && $value->video != null) {
                $vid = "";
                $videos = explode('>|<', $value->video);
                foreach ($videos as $video) {
                    $vid .= asset('storage/app/public/MedicalHistory') . '/' . $video . ">|<";
                }
                $value["video"] = rtrim($vid, '>|<');
            }

            // Documents
            if ($value->document != '' && $value->document != null) {
                $doc = "";
                $documents = explode('>|<', $value->document);
                foreach ($documents as $document) {
                    $doc .= asset('storage/app/public/MedicalHistory') . '/' . $document . ">|<";
                }
                $value["document"] = rtrim($doc, '>|<');
            }
        }


        return response()->json($history, 200);
    }

}
?>