<?php

namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\CPU\ImageManager;


class PetsApprovalApiController extends Controller
{
    public function create_pet(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'pet_name' => 'Required',
            'type' => 'Required',
            'gender' => 'Required',
            'age' => 'Required',
            'city' => 'Required',
            'description' => 'Required',
            'customerid' => 'Required',
            'image1' => 'Required',
            
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $ServiceReq = new PetApproval();

        $ServiceReq->pet_name = $req->get('pet_name');
        $ServiceReq->type = $req->get('type');
        $ServiceReq->gender = $req->get('gender');
        $ServiceReq->age = $req->get('age');
        $ServiceReq->city = $req->get('city');
        $ServiceReq->description = $req->get('description');
        $ServiceReq->customerid = $req->get('customerid');

        if ($req->get('listing_type') != null) {
            $ServiceReq->listing_type = $req->get('listing_type');
        }
        if ($req->file('image1') != null) {
            $ServiceReq->image1 = ImageManager::upload('pet/', 'png', $req->file('image1'));
        }
        if ($req->file('image2') != null) {
            $ServiceReq->image2 = ImageManager::upload('pet/', 'png', $req->file('image2'));
        }
        if ($req->file('image3') != null) {
            $ServiceReq->image3 = ImageManager::upload('pet/', 'png', $req->file('image3'));
        }

        

        // $ServiceReq->customerid = $req->get('customer_id');

        // $image_ids = [];

        // foreach ($req->file('images') as $key => $value) {
        //     $image_ids[] = ImageManager::upload('blog/', 'png', $value);
        // }



        $ServiceReq->save();

        return response()->json("success", 200);
    
    }
    public function get_pets(Request $req){

        $validator = Validator::make($req->all(), [
            'listing_type' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = PetApproval::with('customer')->where('is_approved',1);

        if($req->get('listing_type') != "all"){
            $pets = $pets->where('listing_type', $req->get('listing_type'));
        }

        
        $pets = $pets->get();
        
        foreach ($pets as $key => $value) {
            $pets[$key]["image1"] = $pets[$key]["image1"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image1"] : null;
            $pets[$key]["image2"] = $pets[$key]["image2"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image2"] : null;
            $pets[$key]["image3"] = $pets[$key]["image3"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image3"] : null;
        }
        return response()->json($pets, 200);
    }

    public function get_pets_byCustomerId(Request $req){

        $validator = Validator::make($req->all(), [
            'customer_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = PetApproval::where('customerid', $req->get('customer_id'))->get();
        
        return response()->json($pets, 200);
    }
    
}








?>