<?php

namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use App\Model\PetTransferLog;
use App\Model\MedicalHistory;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\CPU\ImageManager;
use Carbon\Carbon;


class PetsApprovalApiController extends Controller
{
    public function create_pet(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'pet_name' => 'Required',
            'type' => 'Required',
            'gender' => 'Required',
            'age' => 'Required',
            'city' => 'Required',
            'customerid' => 'Required',
            'image1' => 'Required',
            'breed' => 'Required',
            
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $ServiceReq = new PetApproval();

        $ServiceReq->pet_name = $req->get('pet_name');
        $ServiceReq->type = $req->get('type');
        $ServiceReq->gender = $req->get('gender');
        $ServiceReq->age = $req->get('age');
        $ServiceReq->city = $req->get('city');
        $ServiceReq->description = $req->get('description');
        $ServiceReq->customerid = $req->get('customerid');
        $ServiceReq->breed = $req->get('breed');

        if ($req->get('listing_type') != null) {
            $ServiceReq->listing_type = $req->get('listing_type');
        }
        if ($req->file('image1') != null) {
            $ServiceReq->image1 = ImageManager::upload('pet/', 'png', $req->file('image1'));
        }
        if ($req->file('image2') != null) {
            $ServiceReq->image2 = ImageManager::upload('pet/', 'png', $req->file('image2'));
        }
        if ($req->file('image3') != null) {
            $ServiceReq->image3 = ImageManager::upload('pet/', 'png', $req->file('image3'));
        }

        

        



        $ServiceReq->save();

        return response()->json("success", 200);
    
    }
    public function get_pets(Request $req){

        $validator = Validator::make($req->all(), [
            'listing_type' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = PetApproval::with('customer')->where('is_approved',1)->whereDate('expiry', '>=', Carbon::parse()->toDateString());

        if($req->get('listing_type') != "all"){
            $pets = $pets->where('listing_type', $req->get('listing_type'));
        }

        $pets = $pets->get();
        
        foreach ($pets as $key => $value) {
            $pets[$key]["image1"] = $pets[$key]["image1"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image1"] : null;
            $pets[$key]["image2"] = $pets[$key]["image2"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image2"] : null;
            $pets[$key]["image3"] = $pets[$key]["image3"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image3"] : null;
        }
        return response()->json($pets, 200);
    }

    public function get_pets_byCustomerId(Request $req){

        $validator = Validator::make($req->all(), [
            'customer_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = PetApproval::where('customerid', $req->get('customer_id'))->latest()->get();

        foreach ($pets as $key => $value) {
            $pets[$key]["image1"] = $pets[$key]["image1"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image1"] : null;
            $pets[$key]["image2"] = $pets[$key]["image2"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image2"] : null;
            $pets[$key]["image3"] = $pets[$key]["image3"] != null ? asset('storage/app/public/pet') . '/' . $pets[$key]["image3"] : null;

            $pets[$key]["medical_history_count"] = $medicalHistoryCount = MedicalHistory::where('pet_id', $pets[$key]['id'])->count();

            $pets[$key]["appointments_count"] = $medicalHistoryAppointment = MedicalHistory::where('pet_id', $pets[$key]['id'])->
            whereDate('appointment_date', '>', Carbon::parse()->toDateString())->
            count();
        }
        
        return response()->json($pets, 200);
    }

    public function transferHistory(){
        $transferHistories = PetTransferLog::with('from_customer','to_customer', 'pet')->get();
        return response()->json($transferHistories, 200);
    }

    public function update_pet_list(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'id'=>'Required',
            'listing_type' => 'Required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pet =PetApproval::find($req->id);
        if ($pet != null) {
            $pet->listing_type = $req->get('listing_type');
            $pet->is_approved = $req->get('is_approved');
            $pet->save();
            return response()->json("success", 200);
        }
        return response()->json("error", 402);

       
    
    }


    public function create_pet_by_owner(Request $req){
        $validator = Validator::make($req->all(), [
            'pet_name' => 'Required',
            'owner_name' => 'Required',
            'phone_no' => 'Required',
            'city' => 'Required',
            'age' => 'Required',
            'type' => 'Required',
            'listing_type' => 'Required',
            'gender' => 'Required',
            'image1' => 'Required',
            'breed' => 'Required',
            'expiry' => 'Required',

            
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pet =new PetApproval();

        $pet->pet_name = $req->get('pet_name');
        $pet->owner_name = $req->get('owner_name');
        $pet->phone = $req->get('phone_no');
        $pet->city = $req->get('city');
        $pet->type = $req->get('type');
        $pet->listing_type = $req->get('listing_type');
        $pet->gender = $req->get('gender');
        $pet->image1 = $req->get('image1');
        $pet->breed = $req->get('breed');
        $pet->expiry = Carbon::now()->addDays($req->get('expiry'));
        $pet->customerid = $req->get('customerid');

        if ($req->get('age') != null) {
            $pet->age = $req->get('age');
        }

        if ($req->get('listing_type') != null) {
            $pet->listing_type = $req->get('listing_type');
        }
        if ($req->file('image1') != null) {
            $pet->image1 = ImageManager::upload('pet/', 'png', $req->file('image1'));
        }
        if ($req->file('image2') != null) {
            $pet->image2 = ImageManager::upload('pet/', 'png', $req->file('image2'));
        }
        if ($req->file('image3') != null) {
            $pet->image3 = ImageManager::upload('pet/', 'png', $req->file('image3'));
        }

        $pet->save();

        return response()->json("success", 200);


    }



    public function get_pets_forListing(Request $req){

        $validator = Validator::make($req->all(), [
            'customer_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        $pets = PetApproval::where('customerid', $req->get('customer_id'))->where('listing_type',null)->latest()->get();
        
        return response()->json($pets, 200);
    }

    public function get_all_pets(){
        $pet = PetApproval::all()->reverse();
        return response()->json($pet, 200);
    }
    public function getPetById(Request $req){
        $validator = Validator::make($req->all(), [
            'petid' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }
        $pet = PetApproval::where('id',$req->petid)->first();
        if (!$pet) {
            return response()->json([
                "status" => 0,
                'message' => "pet not found"
            ], 403);
        }
        return response()->json( $pet, 200);
    }

    public function deletePet($id){
        try {
            PetApproval::find( $id )->delete();
            return response()->json("success", 200);
        } catch (\Throwable $th) {
            dd( $th);
        }
    }
    
}








?>