<?php
// Added by dSMART
namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\HomeServiceRequest;
use App\Model\HomeServiceBanner;
use App\Model\HomeServiceAddition;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class HomeServiceController extends Controller
{
    public function create_home_service(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'contact_info' => 'required',
            'address' => 'required',
            'request' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 403);
        }

        $ServiceReq = new HomeServiceRequest();

        $ServiceReq->first_name = $req->get('first_name');
        $ServiceReq->last_name = $req->get('last_name');
        $ServiceReq->contact_info = $req->get('contact_info');
        $ServiceReq->address = $req->get('address');
        $ServiceReq->request = $req->get('request');

        $ServiceReq->save();

        return response()->json("success", 200);
    
    }

    public function fetchBanner(){
        $homeServiceBanner = HomeServiceBanner::first();
        for ($i=1; $i <= 5; $i++) {
            if(Str::of($homeServiceBanner["image$i"])->isNotEmpty())
                $homeServiceBanner["image$i"] = asset('storage/app/public/HomeServiceBanner') . '/' . $homeServiceBanner["image$i"];
        }
        return response()->json($homeServiceBanner, 200);
    }
    public function fetchButton(){
        $homeServiceButton = HomeServiceAddition::first();
        $homeServiceButton->button_image = asset('storage/app/public/HomeServiceAddition') . '/' . $homeServiceButton->button_image;
        return response()->json($homeServiceButton, 200);
    }

}
