<?php

namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\Contact;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class ContactController extends Controller
{
    public function create_message(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'name' => 'required',
            'email' => 'required',
            'mobile_number' => 'required',
            'subject' => 'required',
            'message' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 403);
        }

        $ServiceReq = new Contact();

        $ServiceReq->name = $req->get('name');
        $ServiceReq->email = $req->get('email');
        $ServiceReq->mobile_number = $req->get('mobile_number');
        $ServiceReq->subject = $req->get('subject');
        $ServiceReq->message = $req->get('message');

        $ServiceReq->save();

        return response()->json("success", 200);
    
    }

    // public function get_blog(int $blog_id)
    // {
    //     $blogs = Blog::where('id', $blog_id)->first();

    //     return response()->json($blogs, 200);
    
    // }
}

?>