<?php

namespace App\Http\Controllers\api\v4;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\Blog;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class BlogController extends Controller
{
    public function get_blogs(Request $req)
    {
        $blogs = Blog::where('isActive', 1)->latest()->get();

        foreach ($blogs as $key => $value) {
            $blogs[$key]["img"] = asset('storage/app/public/blog') . '/' . $blogs[$key]["img"];
        }

        return response()->json($blogs, 200);
    
    }

    public function get_blog(int $blog_id)
    {
        $blogs = Blog::where('id', $blog_id)->first();
        
        $blogs["img"] = asset('storage/app/public/blog') . '/' . $blogs["img"];

        return response()->json($blogs, 200);
    
    }
}
