<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class PetsApprovalControllerOld extends Controller
{
    public function list(Request $request)
    {
        $query_param = [];
        $search = $request['search'];
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $pet = PetApproval::where(function ($q) use ($key) {
                foreach ($key as $value) {
                    $q->orWhere('pet_name', 'like', "%{$value}%");
                }
            });
            $query_param = ['search' => $request['search']];
        } else {
            $pet = PetApproval::has('customer')->with('customer');
        }

        $pet = $pet->where('listing_type', '!=', null)
            ->whereNull('is_approved')
            ->whereHas('customer')
            ->latest()
            ->paginate(Helpers::pagination_limit())
            ->appends($query_param);

        return view('admin-views.pet-list-approval.list', compact('pet', 'search'));
    }

    public function view($id)
    {
        // $pets = PetApproval::where('id', ">", 0)->update(['is_approved' => null]);
        // $pet = PetApproval::find($id);
        $pet = PetApproval::where("image1", "!=", null)->first();
        $pet["image1"] = asset('storage/app/public/pet') . '/' . $pet["image1"];
        return response()->json([
            'status' => 200,
            'data' => $pet,
        ]);

    }

    public function change_status(Request $req)
    {
        $pet = PetApproval::find($req->get("id"));
        $pet->is_approved = $req->get("status");
        $pet->save();
        return response()->json(200);
    }
}
