<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\HomeServiceRequest;
use App\Model\HomeServiceBanner;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\CPU\ImageManager;

class HomeServiceController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'mobile_number' => 'required',
            'subject' => 'required',
            'message' => 'required',
        ], [
            'mobile_number.required' => 'Mobile Number is Empty!',
            'subject.required' => ' Subject is Empty!',
            'message.required' => 'Message is Empty!',

        ]);
        $contact = new Contact;
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->mobile_number = $request->mobile_number;
        $contact->subject = $request->subject;
        $contact->message = $request->message;
        $contact->save();

        return response()->json(['success' => 'Your Message Send Successfully']);
    }

    public function list(Request $request)
    {        
        $query_param = [];
        $search = $request['search'];
        if ($request->has('search'))
        {
            $key = explode(' ', $request['search']);
            $home_service_requests = HomeServiceRequest::where(function ($q) use ($key) {
                foreach ($key as $value) {
                    $q->orWhere('first_name', 'like', "%{$value}%")
                        ->orWhere('last_name', 'like', "%{$value}%");
                }
            });
            $query_param = ['search' => $request['search']];
        }else{
            $home_service_requests = new HomeServiceRequest();
        }

        if($request->get('from_date') != ""){ 

            $home_service_requests = $home_service_requests->whereDate('created_at', '>=', $request->get('from_date'));
        }
        if($request->get('to_date') != ""){
            $home_service_requests = $home_service_requests->whereDate('created_at', '<=', $request->get('to_date'));
        }
        $home_service_requests = $home_service_requests->latest()->paginate(Helpers::pagination_limit())->appends($query_param);

        $homeServiceBanner = HomeServiceBanner::first();

        return view('admin-views.home-service.list', compact('home_service_requests','search', 'homeServiceBanner'));
    }

    public function updateBanner(Request $request){
        $banner = HomeServiceBanner::first();

        if($banner == null){
            $banner = new HomeServiceBanner();
        }else{
            $banner = HomeServiceBanner::find($banner->id);
        }

        if ($request->file('img')) {
            $banner->image_url = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('img')[0]);
        }
        $banner->content_english = $request->get("content_english");
        $banner->content_arabic = $request->get("content_arabic");
        $banner->content_khurdish = $request->get("content_khurdish");
        $banner->save();
        
        Toastr::success('Home Service Banner Updated Successfully!');
        return back();
    }

    public function view($id)
    {
        $contact = Contact::findOrFail($id);
        return view('admin-views.contacts.view', compact('contact'));
    }

    public function update(Request $request, $id)
    {
        $contact = Contact::find($id);
        $contact->feedback = $request->feedback;
        $contact->seen = 1;
        $contact->update();
        Toastr::success('Feedback  Update successfully!');
        return redirect()->route('admin.contact.list');
    }

    public function destroy(Request $request)
    {
        $contact = Contact::find($request->id);
        $contact->delete();

        return response()->json();
    }

    public function send_mail(Request $request, $id)
    {
        $contact = Contact::findOrFail($id);
        $data = array('body' => $request['mail_body']);
        Mail::send('email-templates.customer-message', $data, function ($message) use ($contact, $request) {
            $message->to($contact['email'], BusinessSetting::where(['type' => 'company_name'])->first()->value)
                ->subject($request['subject']);
        });

        Contact::where(['id' => $id])->update([
            'reply' => json_encode([
                'subject' => $request['subject'],
                'body' => $request['mail_body']
            ])
        ]);

        Toastr::success('Mail sent successfully!');
        return back();
    }

    public function maintainHomeService(){
        $homeServiceBanner = HomeServiceBanner::first();
        return view('admin-views.home-service.maintain-home-service', compact('home_service_requests', 'homeServiceBanner'));
    }
}
