<?php

namespace App\Http\Controllers\Customer\Auth;

use App\CPU\CartManager;
use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\Wishlist;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Laravel\Socialite\Facades\Socialite;
use Session;
use Lcobucci\JWT\Configuration;
use Lcobucci\JWT\Signer\Key\InMemory;
use Lcobucci\JWT\Signer\Ecdsa\Sha256;
use Firebase\JWT\JWT;

class SocialAuthController extends Controller
{
    public function redirectToProvider(Request $request, $service)
    {
        if($service =="apple-mobile"){
            
            return redirect()->away('vetsasigninwithapple://?code='.$request->code.'&id_token='.$request->id_token.'&email='.$request->code);
        }
        return Socialite::driver($service)->redirect();
    }

    // public function handleProviderCallback($service)
    // {
    //     $user_data = Socialite::driver($service)->stateless()->user();

    //     $user = User::where('email', $user_data->getEmail())->first();

    //     $name = explode(' ', $user_data['name']);
    //     if (count($name) > 1) {
    //         $fast_name = implode(" ", array_slice($name, 0, -1));
    //         $last_name = end($name);
    //     } else {
    //         $fast_name = implode(" ", $name);
    //         $last_name = '';
    //     }

    //     if (isset($user) == false) {
    //         $user = User::create([
    //             'f_name' => $fast_name,
    //             'l_name' => $last_name,
    //             'email' => $user_data->getEmail(),
    //             'phone' => '',
    //             'password' => bcrypt($user_data->id),
    //             'is_active' => 1,
    //             'login_medium' => $service,
    //             'social_id' => $user_data->id,
    //             'is_phone_verified' => 0,
    //             'is_email_verified' => 1,
    //             'temporary_token' => Str::random(40),
    //         ]);
    //     } else {
    //         $user->temporary_token = Str::random(40);
    //         $user->save();
    //     }

    //     /*if ($user->phone == '') {
    //     return redirect()->route('customer.auth.update-phone', $user->id);
    //     }*/
    //     //redirect if website user
    //     $message = self::login_process($user, $user_data->getEmail(), $user_data->id);
    //     Toastr::info($message);
    //     return redirect()->route('home');

    // }
    
    public function handleProviderCallback(Request $request, $service)
    {
        $user_data = [];
        if($service == "apple"){
            
            $privateKeyContent = file_get_contents('storage/apple_private_key/AuthKey_23CLWVVTZS.p8');
            
            $teamId = '3M7K7FJB9R';
            $clientId = 'co.vetsa';
            $keyId = '23CLWVVTZS';
            $redirectURL = 'https://vetsa.co/customer/auth/login/apple/callback';
            $config = Configuration::forSymmetricSigner(new Sha256(), InMemory::plainText($privateKeyContent));
            
            
            // Prepare the payload
            $payload = [
                'iss' => $teamId,
                'iat' => time(),
                'exp' => time() + 86400 * 180, // 180 days expiration
                'aud' => 'https://appleid.apple.com',
                'sub' => $clientId,
            ];
    
            // Create the JWT token
            $jwtToken = JWT::encode($payload, $privateKeyContent, 'ES256', $keyId);
        
            $response = Http::asForm()->post('https://appleid.apple.com/auth/token', [
                'client_id' => $clientId,
                'client_secret' => $jwtToken,
                'code' => $request->code,
                'grant_type' => 'authorization_code',
                'redirect_uri' => $redirectURL,
            ]);
            
            if ($response->successful()) {
                $responseData = $response->json();
                
                $accessToken = $responseData['access_token'];
        
                $parts = explode('.', $responseData['id_token']);
                $base64EncodedString = $parts[1];
                $decodedBytes = base64_decode($base64EncodedString);
                $decodedString = utf8_decode($decodedBytes);
                $decodedJson = json_decode($decodedString, true);
                
                $user_data = [
                    'id' => $decodedJson["email"], // Assuming $credential is your object containing authorization code
                    'token' => $responseData['id_token'], // Assuming $credential is your object containing identity token
                    'email' => $decodedJson["email"],
                    'name' => explode('@', $decodedJson["email"])[0]
                ];
                
            } else {
                $user_data = [];
            }
        }else{
            
            $user_data = Socialite::driver($service)->stateless()->user();
        }
        

        $user = User::where('email', $service == "apple" ? $user_data["email"] : $user_data->getEmail())->first();
        
        
        $name = explode(' ', $user_data['name']);
        if (count($name) > 1) {
            $fast_name = implode(" ", array_slice($name, 0, -1));
            $last_name = end($name);
        } else {
            $fast_name = implode(" ", $name);
            $last_name = '';
        }

        if (isset($user) == false) {
            $user = User::create([
                'f_name' => $fast_name,
                'l_name' => $last_name,
                'email' => $service == "apple" ? $user_data["email"] : $user_data->getEmail(),
                'phone' => '',
                'password' => bcrypt($service == "apple" ? $user_data['id'] : $user_data->id),
                'is_active' => 1,
                'login_medium' => $service,
                'social_id' => $service == "apple" ? $user_data['id'] : $user_data->id,
                'is_phone_verified' => 0,
                'is_email_verified' => 1,
                'temporary_token' => Str::random(40)
            ]);
        } else {
            $user->temporary_token = Str::random(40);
            $user->save();
        }

        /*if ($user->phone == '') {
            return redirect()->route('customer.auth.update-phone', $user->id);
        }*/
        //redirect if website user
        $message = self::login_process($user, $service == "apple" ? $user_data["email"] : $user_data->getEmail(), $service == "apple" ? $user_data['id'] : $user_data->id);
        Toastr::info($message);
        return redirect()->route('home');
    }

    public function editPhone($id)
    {
        $user = User::find($id);
        return view('customer-view.auth.update-phone', compact('user'));
    }

    public function updatePhone(Request $request)
    {
        $request->validate([
            'f_name' => 'required',
            'l_name' => 'required',
            'phone' => 'required|unique:users|min:11',
        ], [
            'f_name.required' => 'First Name is Required',
            'l_name.required' => 'Last Name is Required',
            'phone.required' => 'Phone Number is Required',
            'unique' => 'Phone Number Must Be Unique!',
            'phone.min' => 'Phone Number Should be Minimum of 11 Character'
        ]);

        $user = User::find($request->id);
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->phone = $request->phone;
        $user->is_active = 1;
        $user->save();

        return redirect(route('customer.auth.check', [$user->id]));
    }

    public static function login_process($user, $email, $password)
    {
        $company_name = BusinessSetting::where('type', 'company_name')->first();

        if ($user->is_active && auth('customer')->attempt(['email' => $email, 'password' => $password], true)) {
            $wish_list = Wishlist::whereHas('wishlistProduct',function($q){
                return $q;
            })->where('customer_id', $user->id)->pluck('product_id')->toArray();

            session()->put('wish_list', $wish_list);
            $message = 'Welcome to ' . $company_name->value . '!';
            CartManager::cart_to_db();
        } else {
            $message = 'Credentials are not matched or your account is not active!';
        }

        return $message;
    }
    
    // public function handleProviderCallback(Request $request, $service)
    // {
    //     $user_data = [];
    //     if($service == "apple"){
            
    //         $privateKeyContent = file_get_contents('storage/apple_private_key/AuthKey_23CLWVVTZS.p8');
            
    //         $teamId = '3M7K7FJB9R';
    //         $clientId = 'co.vetsa';
    //         $keyId = '23CLWVVTZS';
    //         $redirectURL = 'https://vetsa.co/customer/auth/login/apple/callback';
    //         $config = Configuration::forSymmetricSigner(new Sha256(), InMemory::plainText($privateKeyContent));
            
            
    //         // Prepare the payload
    //         $payload = [
    //             'iss' => $teamId,
    //             'iat' => time(),
    //             'exp' => time() + 86400 * 180, // 180 days expiration
    //             'aud' => 'https://appleid.apple.com',
    //             'sub' => $clientId,
    //         ];
    
    //         // Create the JWT token
    //         $jwtToken = JWT::encode($payload, $privateKeyContent, 'ES256', $keyId);
        
    //         $response = Http::asForm()->post('https://appleid.apple.com/auth/token', [
    //             'client_id' => $clientId,
    //             'client_secret' => $jwtToken,
    //             'code' => $request->code,
    //             'grant_type' => 'authorization_code',
    //             'redirect_uri' => $redirectURL,
    //         ]);
            
    //         if ($response->successful()) {
    //             $responseData = $response->json();
                
    //             $accessToken = $responseData['access_token'];
        
    //             $parts = explode('.', $responseData['id_token']);
    //             $base64EncodedString = $parts[1];
    //             $decodedBytes = base64_decode($base64EncodedString);
    //             $decodedString = utf8_decode($decodedBytes);
    //             $decodedJson = json_decode($decodedString, true);
                
    //             $user_data = [
    //                 'id' => $decodedJson["email"], // Assuming $credential is your object containing authorization code
    //                 'token' => $responseData['id_token'], // Assuming $credential is your object containing identity token
    //                 'email' => $decodedJson["email"],
    //                 'name' => explode('@', $decodedJson["email"])[0]
    //             ];
                
    //         } else {
    //             $user_data = [];
    //         }
    //     }else{
            
    //         $user_data = Socialite::driver($service)->stateless()->user();
    //     }
        

    //     $user = User::where('email', $service == "apple" ? $user_data["email"] : $user_data->getEmail())->first();
        
        
    //     $name = explode(' ', $user_data['name']);
    //     if (count($name) > 1) {
    //         $fast_name = implode(" ", array_slice($name, 0, -1));
    //         $last_name = end($name);
    //     } else {
    //         $fast_name = implode(" ", $name);
    //         $last_name = '';
    //     }

    //     if (isset($user) == false) {
    //         $user = User::create([
    //             'f_name' => $fast_name,
    //             'l_name' => $last_name,
    //             'email' => $service == "apple" ? $user_data["email"] : $user_data->getEmail(),
    //             'phone' => '',
    //             'password' => bcrypt($service == "apple" ? $user_data['id'] : $user_data->id),
    //             'is_active' => 1,
    //             'login_medium' => $service,
    //             'social_id' => $service == "apple" ? $user_data['id'] : $user_data->id,
    //             'is_phone_verified' => 0,
    //             'is_email_verified' => 1,
    //             'temporary_token' => Str::random(40)
    //         ]);
    //     } else {
    //         $user->temporary_token = Str::random(40);
    //         $user->save();
    //     }

    //     /*if ($user->phone == '') {
    //         return redirect()->route('customer.auth.update-phone', $user->id);
    //     }*/
    //     //redirect if website user
    //     $message = self::login_process($user, $service == "apple" ? $user_data["email"] : $user_data->getEmail(), $service == "apple" ? $user_data['id'] : $user_data->id);
    //     Toastr::info($message);
    //     return redirect()->route('home');
    // }
}
