<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use App\User;
use App\Model\PetTransferLog;
use Illuminate\Support\Facades\DB;
use App\Model\MedicalHistory;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\CPU\ImageManager;
use DateTime;
use Rap2hpoutre\FastExcel\FastExcel;


class PetsMedicalHistoryController extends Controller
{
    public function list(Request $request)
    {
        try {
            $query_param = [];
            $search = $request['search'];
            $pet = PetApproval::has('customer')->with('customer');
            if ($request->has('search')) {
                $key = explode(' ', $request['search']);
                $pet = $pet->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->orWhere('pet_name', 'like', "%{$value}%")
                            ->orWhereHas('customer', function ($query) use ($value) {
                                $query->where('f_name', 'like', "%{$value}%")
                                    ->orWhere('l_name', 'like', "%{$value}%");
                            });
                    }
                });
                $query_param = ['search' => $request['search']];
            }
            $pet = $pet->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
            // dd($pet);

            return view('admin-views.pet-medical-history.list', compact('pet', 'search'));
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function view($id)
    {
        $pet = PetApproval::where('id', $id)->first();
        $all = MedicalHistory::where("pet_id", $id)->latest()->paginate(10);
        $vaccineData = MedicalHistory::where("pet_id", $id)->where("type", "vaccine")->latest()->paginate(10);
        $alergy = MedicalHistory::where("pet_id", $id)->where("type", "alergy")->latest()->paginate(10);
        $parasite = MedicalHistory::where("pet_id", $id)->where("type", "parasite")->latest()->paginate(10);
        $examination = MedicalHistory::where("pet_id", $id)->where("type", "examination")->latest()->paginate(10);
        $surgery = MedicalHistory::where("pet_id", $id)->where("type", "surgery")->latest()->paginate(10);
        $prescription = MedicalHistory::where("pet_id", $id)->where("type", "prescription")->latest()->paginate(10);
        $lab_test = MedicalHistory::where("pet_id", $id)->where("type", "lab_test")->latest()->paginate(10);
        // Split the "test" column into parts using explode
        // $lab_test = $lab_test->map(function ($item) {
        //     $parts = explode('>|<', $item->test);
        //     $item->test = isset($parts[1]) ? $parts[1] : '';
        //     $item->result = isset($parts[3]) ? $parts[3] : '';
        //     $item->normal = isset($parts[5]) ? $parts[5] : '';
        //     return $item;
        // });
        $radiology = MedicalHistory::where("pet_id", $id)->where("type", "radiology")->latest()->paginate(10);
        $pathology = MedicalHistory::where("pet_id", $id)->where("type", "pathology")->latest()->paginate(10);
        $transferHistory = PetTransferLog::with('from_customer', 'to_customer', 'pet')->where('pet_id', $id)->get()->reverse();
        $cities = [
            "Baghdad",
            "Mosul",
            "Al Başrah",
            "Kirkuk",
            "As Sulaymānīyah",
            "Ar Ramādī",
            "Erbil",
            "An Najaf",
            "Karbalā’",
            "An Nāşirīyah",
            "Al Ḩillah",
            "Al ‘Amārah",
            "Ba‘qūbah",
            "Ad Dīwānīyah",
            "Az Zubayr",
            "Dahūk",
            "Al Fallūjah",
            "Al Kūt",
            "Ash Shāmīyah",
            "Al Qurnah",
            "Al Ḩamzah",
            "Rāniyah",
            "Sab‘ al Būr",
            "Ash Shaţrah",
            "Kalār",
            "Abī al Khaşīb",
            "Zākhū",
            "As Samāwah",
            "‘Aqrah",
            "At Tājī",
            "Abū Ghurayb",
            "Khānaqīn",
            "Al Kūfah",
            "Sāmarrā’",
            "Al Miqdādīyah",
            "Nāḩiyat Ghammās",
            "Nāḩiyat Khān Banī Sa‘d",
            "Sawrān",
            "Ţūz Khūrmātū",
            "Salmān Bāk",
            "Qal‘at Sukkar",
            "Umm Qaşr",
            "Tikrīt",
            "Al Fāw",
            "Nāḩiyat al Iskandarīyah",
            "Aţ Ţārmīyah"
        ];


        return view('admin-views.pet-medical-history.history', compact('pet', 'vaccineData', 'alergy', 'parasite', 'examination', 'surgery', 'prescription', 'lab_test', 'radiology', 'pathology', 'transferHistory', 'all', 'cities'));
    }
    public function edit($id)
    {
        $history = MedicalHistory::find($id);

        // images
        if ($history->images != '' && $history->images != null) {

            $res = "";
            $images = explode('>|<', $history->images);
            foreach ($images as $image) {
                $res .= asset('storage/app/public/MedicalHistory') . '/' . $image . ">|<";
            }
            $history["images"] = $res;
        }



        // videos

        if ($history->video != '' && $history->video != null) {
            $vid = "";
            $videos = explode('>|<', $history->video);
            foreach ($videos as $video) {
                $vid .= asset('storage/app/public/MedicalHistory') . '/' . $video . ">|<";
            }

            $history["video"] = $vid;
        }

        // Documents
        if ($history->document != '' && $history->document != null) {
            $doc = "";
            $documents = explode('>|<', $history->document);
            foreach ($documents as $document) {
                $doc .= asset('storage/app/public/MedicalHistory') . '/' . $document . ">|<";
            }

            $history["document"] = $doc;
        }


        return response()->json([
            'status' => 200,
            'data' => $history,
        ]);
    }

    public function transferHistory($id)
    {
        $transferHistories = PetTransferLog::with('from_customer', 'to_customer', 'pet')->where('pet_id', $id)->get();
        return view('admin-views.pet-medical-history.history', compact('transferHistories'));
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'date' => 'required',
            'pet_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 500);
        }

        if ($request->get("id") != null) {
            $pet = MedicalHistory::find($request->id);
            $msg = 'History updated successfully!';
        } else {
            $pet = new MedicalHistory();
            $msg = 'History added successfully!';
        }

        $pet->title = $request->title;
        $pet->tempurature = $request->tempurature;
        $pet->weight = $request->weight;
        $pet->symptoms = implode('>|<', $request->input('symptoms', []));
        $pet->diagnosis = implode('>|<', $request->input('diagnosis', []));
        $pet->result = $request->result;

        if ($request->doctor) {
            $pet->doctor = $request->doctor;
        } else {
            $pet->doctor = '';
        }
        if ($request->place) {
            $pet->place = $request->place;
        } else {
            $pet->place = '';
        }

        $drugArray = $request->input('drug', []);
        $doseArray = $request->input('dose', []);

        $combinedArray = [];

        foreach ($drugArray as $key => $drug) {
            $combinedArray[] = $drug . '|>|' . $doseArray[$key];
        }

        $pet->drug = implode('<|||>', $combinedArray);



        $testArray = $request->input('test', []);
        $labTestResultArray = $request->input('lab_test_result', []);
        $labTestNormalArray = $request->input('lab_test_normal', []);

        $combinedTestArray = [];

        foreach ($testArray as $key => $test) {
            $combinedTestArray[] = $test . '|>|' . $labTestResultArray[$key] . '|<|' . $labTestNormalArray[$key];
        }

        $pet->test = implode('<|||>', $combinedTestArray);
        $pet->type = $request->type;
        $pet->date = $request->date;
        $pet->pet_id = $request->pet_id;
        if ($request->treatment != null) {
            $pet->treatment = $request->treatment;
        }


        if ($request->get("next_due_in") != null) {
            $pet->next_due_in = $request->next_due_in;
            $pet->period = $request->period;
            $pet->appointment_date = $request->appointment_date;

            if ($request->type == 'vaccine' || $request->type == 'parasite') {
                if ($request->date == $request->appointment_date || $request->date > $request->appointment_date) {
                    Toastr::error('The next appointment date must be later than the previous appointment date.');
                    return back();
                }
            }
        } else {
            $pet->appointment_date = null;
        }


        if ($request->get("notes") != null) {
            $pet->notes = $request->notes;
        }

        // images

        $imageUrls = "";
        if ($request->file("images") != null) {
            foreach ($request->file("images") as $img) {
                $imageUrls .= ImageManager::upload('MedicalHistory/', $img->extension(), $img) . ">|<";
            }
            $pet->images = rtrim($imageUrls, '>|<');
        }


        // videos
        $videoUrls = "";
        if ($request->file("video") != null) {
            foreach ($request->file("video") as $vid) {
                $videoUrls .= ImageManager::upload('MedicalHistory/', $vid->extension(), $vid) . ">|<";
            }
            $pet->video = rtrim($videoUrls, '>|<');
        }


        // documents
        $documentUrls = "";
        if ($request->file("document") != null) {
            foreach ($request->file("document") as $doc) {
                $documentUrls .= ImageManager::upload('MedicalHistory/', $doc->extension(), $doc) . ">|<";
            }
            $pet->document = rtrim($documentUrls, '>|<');
        }

        $pet->save();
        Toastr::success($msg);
        return back();
    }
    public function delete(Request $request)
    {
        $history = MedicalHistory::find($request->id);
        MedicalHistory::where('id', $request->id)->delete();
        Toastr::success('History deleted successfully');
        return response()->json(200);
    }
    public function addMicrochipId(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'microchip_id' => 'required',
        ]);
        $pet = PetApproval::find($request->id);
        $pet->microchip_id = $request->microchip_id;
        $pet->save();

        Toastr::success('Microchip id updated successfully!');
        return back();
    }
    // public function transferPet(Request $request){
    //     $validator = Validator::make($request->all(), [
    //         'customerid' => 'required',
    //     ]);
    //     $pet = PetApproval::find($request->id);
    //     $pet->customerid =$request->customerid;
    //     $pet->save();


    //     Toastr::success('Pet transfered successfully!');
    //     return back();
    // }

    public function transferPet(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'toCustomerid' => 'required',
        ]);
        $pet = PetApproval::find($request->PetId);
        if ($pet) {
            $pet->customerid = $request->toCustomerid;
            $pet->save();

            $petTransferLog = new PetTransferLog();
            $petTransferLog->from_customer_id = $request->fromCustomerId;
            $petTransferLog->to_customer_id = $request->toCustomerid;
            $petTransferLog->pet_id = $request->PetId;
            $petTransferLog->save();



            Toastr::success('Pet transferred successfully!');
        } else {
            Toastr::error('Pet not found');
        }
        return back();
    }

    public function editPetDetails(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'name' => 'Required',
            'type' => 'Required',
            'breed' => 'Required',
            'gender' => 'Required',
            'dob' => 'Required',
            'city' => 'Required',
        ]);

        if ($validator->fails()) {
            foreach ($validator->messages()->get("*") as $key => $value) {
                Toastr::error(json_encode($key . " " . $value[0]));
            }
            return back();
        }

        $pet = PetApproval::find($req->id);

        $pet->pet_name = $req->name;
        $pet->type = $req->type;
        $pet->gender = $req->gender;
        $pet->breed = $req->breed;
        $pet->age = $req->dob;
        $pet->city = $req->city;
        if ($req->description != null) {
            $pet->description = $req->description;
        }

        $pet->update();
        Toastr::success('Pet detail updated successfully!');
        return back();
    }

    public function editCustomerDetails(Request $req)
    {
        $validator = Validator::make($req->all(), [
            'f_name' => 'Required',
            'l_name' => 'Required',
            'email' => 'Required',
            'phone' => 'Required',
        ]);
        if ($validator->fails()) {
            foreach ($validator->messages()->get("*") as $key => $value) {
                Toastr::error(json_encode($key . " " . $value[0]));
            }
            return back();
        }
        $pet = User::find($req->id);

        $pet->f_name = $req->f_name;
        $pet->l_name = $req->l_name;
        $pet->phone = $req->phone;
        $pet->email = $req->email;

        $pet->update();
        Toastr::success('Pet detail updated successfully!');
        return back();
    }
    public function export(Request $request, $id)
    {
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $history = MedicalHistory::where("pet_id", $id)
                ->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->orWhere('f_name', 'like', "%{$value}%")
                            ->orWhere('l_name', 'like', "%{$value}%")
                            ->orWhere('phone', 'like', "%{$value}%")
                            ->orWhere('email', 'like', "%{$value}%");
                    }
                });
        } else {
            $history = MedicalHistory::where("pet_id", $id);
        }

        $items = $history->latest()->select('type', 'title', 'date', 'notes', 'appointment_date')->get();

        // Format the dates before exporting
        $items = $items->map(function ($item) {
            $item->date = date('Y-m-d', strtotime($item->date));
            $appointmentDate = new DateTime($item->appointment_date);
            $item->appointment_date = $appointmentDate->format('Y-m-d H:i:s');
            return $item;
        });

        return (new FastExcel($items))->download('history.xlsx');
    }
    public function exportbyId(Request $request, $id)
    {

        // if ($request->has('search')) {
        //     $key = explode(' ', $request['search']);
        //     $history = MedicalHistory::where("id", $id)
        //         ->where(function ($q) use ($key) {
        //             foreach ($key as $value) {
        //                 $q->orWhere('f_name', 'like', "%{$value}%")
        //                     ->orWhere('l_name', 'like', "%{$value}%")
        //                     ->orWhere('phone', 'like', "%{$value}%")
        //                     ->orWhere('email', 'like', "%{$value}%");
        //             }
        //         });
        // } else {
        $history = MedicalHistory::where("id", $id);
        // }
        $items = $history->latest()->select('type', 'title', 'date', 'notes', 'appointment_date')->get();
        $items = $items->map(function ($item) {
            $item->date = date('Y-m-d', strtotime($item->date));
            $appointmentDate = new DateTime($item->appointment_date);
            $item->appointment_date = $appointmentDate->format('d-M-y');
            return $item;
        });

        return (new FastExcel($items))->download('history.xlsx');
    }
}
