<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\HomeServiceRequest;
use App\Model\HomeServiceBanner;
use App\Model\HomeServiceAddition;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\CPU\ImageManager;
use App\Model\Translation;


class HomeServiceController extends Controller
{
    public function list(Request $request)
    {
        $query_param = [];
        $search = $request['search'];
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $home_service_requests = HomeServiceRequest::where(function ($q) use ($key) {
                foreach ($key as $value) {
                    $q->orWhere('first_name', 'like', "%{$value}%")
                        ->orWhere('last_name', 'like', "%{$value}%");
                }
            });
            $query_param = ['search' => $request['search']];
        } else {
            $home_service_requests = new HomeServiceRequest();
        }

        if ($request->get('from_date') != "") {

            $home_service_requests = $home_service_requests->whereDate('created_at', '>=', $request->get('from_date'));
        }
        if ($request->get('to_date') != "") {
            $home_service_requests = $home_service_requests->whereDate('created_at', '<=', $request->get('to_date'));
        }
        $home_service_requests = $home_service_requests->latest()->paginate(Helpers::pagination_limit())->appends($query_param);

        $homeServiceBanner = HomeServiceBanner::first();
        return view('admin-views.home-service.list', compact('home_service_requests', 'search', 'homeServiceBanner'));
    }

    public function updateBanner(Request $request)
    {
        $banner = HomeServiceBanner::first();

        if ($banner == null) {
            $banner = new HomeServiceBanner();
        } else {
            $banner = HomeServiceBanner::find($banner->id);
        }

        $banner->description = $request->description[array_search('en', $request->lang)];

        $banner->save();

        foreach ($request->lang as $index => $key) {
            if ($request->description[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\HomeServiceBanner',
                        'translationable_id' => $banner->id,
                        'locale' => $key,
                        'key' => 'description'
                    ],
                    ['value' => $request->description[$index]]
                );

            }
        }

        Toastr::success('Home Service Banner Updated Successfully!');
        return back();
    }
    public function updateButton(Request $request)
    {
        $button = HomeServiceAddition::first();

        if ($button == null) {
            $button = new HomeServiceAddition();
        } else {
            $button = HomeServiceAddition::find($button->id);
        }

        if ($request->file('file')) {
            $button->button_image = ImageManager::upload('HomeServiceAddition/', 'png', $request->file('file')[0]);
        }
        $button->text = $request->text[array_search('en', $request->lang)];
        $button->text_color = $request->text_color;
        $button->save();

        foreach ($request->lang as $index => $key) {
            if ($request->text[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\HomeServiceAddition',
                        'translationable_id' => $button->id,
                        'locale' => $key,
                        'key' => 'text'
                    ],
                    ['value' => $request->text[$index]]
                );

            }
        }

        Toastr::success('Home Service Button Updated Successfully!');
        return back();
    }

    public function updateBannerImage(Request $request)
    {
        $banner = HomeServiceBanner::first();
        $action = $request->input('action');
        $index = $request->imageIndex;

        if ($banner != null) {
            if ($action == "update") {
                if ($index == 1) {
                    $banner->image1 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file')[0]);
                } else if ($index == 2) {
                    $banner->image2 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file')[0]);
                } else if ($index == 3) {
                    $banner->image3 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file')[0]);
                } else if ($index == 4) {
                    $banner->image4 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file')[0]);
                } else {
                    $banner->image5 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file')[0]);
                }
                $banner->save();
                Toastr::success('Updated Successfully !');
                return back();
            } else {
                if ($index == 1) {
                    $banner->image1 = null;
                } else if ($index == 2) {
                    $banner->image2 = null;
                } else if ($index == 3) {
                    $banner->image3 = null;
                } else if ($index == 4) {
                    $banner->image4 = null;
                } else {
                    $banner->image5 = null;
                }
                $banner->save();
                Toastr::success('Deleted Successfully !');
                return back();
            }
        }
    }

    public function uploadBannerImg(Request $request)
    {
        $banner = HomeServiceBanner::first();

        if ($banner != null) {
            if ($banner->image1 == null) {
                $banner->image1 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file'));
            } else if ($banner->image2 == null) {
                $banner->image2 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file'));
            } else if ($banner->image3 == null) {
                $banner->image3 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file'));
            } else if ($banner->image4 == null) {
                $banner->image4 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file'));
            } else {
                $banner->image5 = ImageManager::upload('HomeServiceBanner/', 'png', $request->file('file'));
            }
            $banner->save();
            Toastr::error('Banner Uploaded Successfully');
        } else {
            Toastr::error('Save Banner first to Upload Image');
            return back();
        }
    }

    // public function view($id)
    // {
    //     $home_service_requests = HomeServiceRequest::where('id', $id)->first();
    //     return response()->json([
    //         'status'=>200,
    //         'data' => $home_service_requests,
    //     ]);
    // }

    public function view($id)
    {
        // $pets = PetApproval::where('id', ">", 0)->update(['is_approved' => null]);
        // $pet = PetApproval::where("image1", "!=", null)->first();
        $home_service_requests = HomeServiceRequest::where("id", $id)->get();
        return response()->json([
            'status' => 200,
            'data' => $home_service_requests,
        ]);

    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'status' => 'required',
        ], [
            'status.required' => 'Status is required!',
        ]);
        $home_service_requests = HomeServiceRequest::find($request->id);
        $home_service_requests->id = $request->id;
        $home_service_requests->status = $request->status;
        $home_service_requests->comment = $request->comment;
        $home_service_requests->save();
        Toastr::success('Status updated successfully!');
        return back();
    }

    public function destroy(Request $request)
    {
        $contact = Contact::find($request->id);
        $contact->delete();

        return response()->json();
    }

    public function send_mail(Request $request, $id)
    {
        $contact = Contact::findOrFail($id);
        $data = array('body' => $request['mail_body']);
        Mail::send('email-templates.customer-message', $data, function ($message) use ($contact, $request) {
            $message->to($contact['email'], BusinessSetting::where(['type' => 'company_name'])->first()->value)
                ->subject($request['subject']);
        });

        Contact::where(['id' => $id])->update([
            'reply' => json_encode([
                'subject' => $request['subject'],
                'body' => $request['mail_body']
            ])
        ]);

        Toastr::success('Mail sent successfully!');
        return back();
    }

    public function maintainHomeService($id)
    {
        $homeServiceBanner = HomeServiceBanner::where(['id' => $id])->withoutGlobalScopes()->first();
        // dd($button);
        return view('admin-views.home-service.maintain-home-service', compact('homeServiceBanner'));
    }

    public function maintainHomeServiceButton($id){
        $button = HomeServiceAddition::where(['id' => $id])->withoutGlobalScopes()->first();
        return view('admin-views.home-service.maintain-home-service-button',compact('button'));
    }
}
