<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\Blog;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\CPU\ImageManager;
use App\Model\Translation;

class BlogController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'img' => 'required',
        ]);
        $blog = new Blog();
        $blog->title = $request->title[array_search('en', $request->lang)];
        $blog->description = $request->description[array_search('en', $request->lang)];
        $blog->img = ImageManager::upload('blog/', 'png', $request->file('img')[0]);
        $blog->isActive = 1;
        $blog->save();

        foreach ($request->lang as $index => $key) {
            if ($request->title[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\Blog',
                        'translationable_id' => $blog->id,
                        'locale' => $key,
                        'key' => 'title'
                    ],
                    ['value' => $request->title[$index]]
                );
            }
            if ($request->description[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\Blog',
                        'translationable_id' => $blog->id,
                        'locale' => $key,
                        'key' => 'description'
                    ],
                    ['value' => $request->description[$index]]
                );
            }
        }

        Toastr::success('Blog added successfully!');
        return back();
    }

    public function list(Request $request)
    {
        try {
            $query_param = [];
            $search = $request['search'];
            if ($request->has('search')) {
                $key = explode(' ', $request['search']);
                $blog = Blog::where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->orWhere('title', 'like', "%{$value}%");
                    }
                });
                $query_param = ['search' => $request['search']];
            } else {
                $blog = new Blog();
            }
            $blog = $blog->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
            return view('admin-views.blog.list', compact('blog', 'search'));
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function change_status(Request $req)
    {

        $blog = Blog::find($req->get("id"));
        $blog->isActive = ($blog["isActive"] == 0 && $blog["isActive"] == null) ? 1 : 0;
        $blog->save();
        return response()->json(200);

    }

    public function get_blogs(Request $request)
    {
        try {
            $blogs = Blog()::all();

            return $blogs;
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function add_new()
    {
        $br = Blog::latest()->paginate(Helpers::pagination_limit());
        $language = \App\Model\BusinessSetting::where('type', 'pnc_language')->first();
        $language = $language->value ?? null;
        $default_lang = 'en';

        return view('admin-views.blog.add-new', compact('br', 'language', 'default_lang'));
    }
    public function edit($id)
    {
        $blog = Blog::where(['id' => $id])->withoutGlobalScopes()->first();
        return view('admin-views.blog.edit', compact('blog'));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ], [
            'title.required' => 'title is required!',
            'description.required' => 'description is required!',
        ]);

        // dd($request->description[array_search('en', $request->lang)]);
        $blog = Blog::find($id);
        $blog->title = $request->title[array_search('en', $request->lang)];
        $blog->description = $request->description[array_search('en', $request->lang)];
        if ($request->file('img')) {
            $blog->img = ImageManager::update('blog/', $blog['img'], 'png', $request->file('img')[0]);
        }
        $blog->save();

        foreach ($request->lang as $index => $key) {
            if ($request->title[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\Blog',
                        'translationable_id' => $blog->id,
                        'locale' => $key,
                        'key' => 'title'
                    ],
                    ['value' => $request->title[$index]]
                );
            }
            if ($request->description[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    [
                        'translationable_type' => 'App\Model\Blog',
                        'translationable_id' => $blog->id,
                        'locale' => $key,
                        'key' => 'description'
                    ],
                    ['value' => $request->description[$index]]
                );
            }
        }

        Toastr::success('Blog updated successfully!');
        // return redirect('/admin/blog/list');
        return back();
    }

    public function delete(Request $request)
    {
        $blog = Blog::find($request->id);
        ImageManager::delete('blog/' . $blog['img']);
        Blog::where('id', $request->id)->delete();
        return response()->json(200);
    }

    public function send_mail(Request $request, $id)
    {
        $contact = Contact::findOrFail($id);
        $data = array('body' => $request['mail_body']);
        Mail::send('email-templates.customer-message', $data, function ($message) use ($contact, $request) {
            $message->to($contact['email'], BusinessSetting::where(['type' => 'company_name'])->first()->value)
                ->subject($request['subject']);
        });

        Contact::where(['id' => $id])->update([
            'reply' => json_encode([
                'subject' => $request['subject'],
                'body' => $request['mail_body']
            ])
        ]);

        Toastr::success('Mail sent successfully!');
        return back();
    }
}
