<?php

namespace App\Console\Commands;

use App\Model\MedicalHistory;
use App\Model\Notification;
use App\Model\PetApproval;
use App\User;
use Illuminate\Console\Command;
use Carbon\Carbon;
use App\CPU\Helpers;
use Illuminate\Support\Facades\DB;

class PushAppointmentsNotifications extends Command
{
    protected $signature = 'PushAppointmentsNotifications:run';
    protected $description = 'Push Appointment Announcement to all users at 9 am';

    public function handle()
    {
        try {

            $date = Carbon::now();
            $history = MedicalHistory::with('pet')->whereDate('appointment_date', $date->toDateString())->get();

            foreach ($history as $value) {

                $notification = new Notification;
                $notification->title = "Appointment Remainder";
                $notification->description = "Today is " . $value->pet->pet_name . "'s Appointment for " . $value->type;
                $notification->image = $value["pet"]["image1"] = $value["pet"]["image1"] != null ? asset('storage/app/public/pet') . '/' . $value["pet"]["image1"] : null;
                $notification->status = 1;
                $notification->notification_count = 1;
                $notification->pet_id = $value["pet"]["id"];

                $user = User::find($value["pet"]["customerid"]);

                if ($user != null) {
                    try {
                        Helpers::send_push_notif_to_device($user["cm_firebase_token"], $notification);
                    } catch (\Exception $e) {
                        continue;
                        // dd($e);
                    }
                }
            }

            $history = MedicalHistory::with('pet')->whereDate('appointment_date', $date->addDays(1)->toDateString())->get();
            foreach ($history as $value) {

                $notification = new Notification;
                $notification->title = "Appointment Remainder";
                $notification->description = "Tomorrow is " . $value->pet->pet_name . "'s Appointment for " . $value->type;
                $notification->image = $value["pet"]["image1"] = $value["pet"]["image1"] != null ? asset('storage/app/public/pet') . '/' . $value["pet"]["image1"] : null;
                $notification->status = 1;
                $notification->notification_count = 1;
                $notification->pet_id = $value["pet"]["id"];

                $user = User::find($value["pet"]["customerid"]);

                if ($user != null) {
                    try {
                        Helpers::send_push_notif_to_device($user["cm_firebase_token"], $notification);
                    } catch (\Exception $e) {
                        continue;
                    }
                }
            }

            $history = MedicalHistory::with('pet')->whereDate('appointment_date', $date->addDays(7)->toDateString())->get();
            foreach ($history as $value) {

                $notification = new Notification;
                $notification->title = "Appointment Remainder";
                $notification->description = "On " . Carbon::parse($value->appointment_date)->toDateString() . " " . $value->pet->pet_name . "'s Appointment for " . $value->type;
                $notification->image = $value["pet"]["image1"] = $value["pet"]["image1"] != null ? asset('storage/app/public/pet') . '/' . $value["pet"]["image1"] : null;
                $notification->status = 1;
                $notification->notification_count = 1;
                $notification->pet_id = $value["pet"]["id"];

                $user = User::find($value["pet"]["customerid"]);

                if ($user != null) {
                    try {
                        Helpers::send_push_notif_to_device($user["cm_firebase_token"], $notification);
                    } catch (\Exception $e) {
                        continue;
                    }
                }
            }
        } catch (\Exception $ex) {
            dd($ex);
        }


    }
}