<?php
namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\BusinessSetting;
use App\Model\PetApproval;
use App\Model\PetTransferLog;
use Illuminate\Support\Facades\DB;
use App\Model\MedicalHistory;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\CPU\ImageManager;


class PetsMedicalHistoryController extends Controller
{
    public function list(Request $request)
{
    try {
        $query_param = [];
        $search = $request['search'];
        $pet = PetApproval::has('customer')->with('customer');
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $pet = $pet->where(function ($q) use ($key) {
                foreach ($key as $value) {
                    $q->orWhere('pet_name', 'like', "%{$value}%")
                        ->orWhereHas('customer', function ($query) use ($value) {
                            $query->where('f_name', 'like', "%{$value}%")
                                ->orWhere('l_name', 'like', "%{$value}%");
                        });
                }
            });
            $query_param = ['search' => $request['search']];
        }
        $pet = $pet->latest()->paginate(Helpers::pagination_limit())->appends($query_param);

        return view('admin-views.pet-medical-history.list', compact('pet', 'search'));
    } catch (\Throwable $th) {
        throw $th;
    }
}

public function view($id)
{
    $pet = PetApproval::where('id', $id)->first();
    $vaccineData = MedicalHistory::where("pet_id", $id)->where("type", "vaccine")->latest()->paginate(10);
    $alergy = MedicalHistory::where("pet_id", $id)->where("type", "alergy")->latest()->paginate(10);
    $parasite = MedicalHistory::where("pet_id", $id)->where("type", "parasite")->latest()->paginate(10);
    $examination = MedicalHistory::where("pet_id", $id)->where("type", "examination")->latest()->paginate(10);
    
    $surgery = MedicalHistory::where("pet_id", $id)->where("type", "surgery")->latest()->paginate(10);
    $prescription = MedicalHistory::where("pet_id", $id)->where("type", "prescription")->latest()->paginate(10);


    $lab_test = MedicalHistory::where("pet_id", $id)->where("type", "lab_test")->latest()->paginate(10);
    // Split the "test" column into parts using explode
    // $lab_test = $lab_test->map(function ($item) {
    //     $parts = explode('>|<', $item->test);
    //     $item->test = isset($parts[1]) ? $parts[1] : '';
    //     $item->result = isset($parts[3]) ? $parts[3] : '';
    //     $item->normal = isset($parts[5]) ? $parts[5] : '';
    //     return $item;
    // });
    $radiology = MedicalHistory::where("pet_id", $id)->where("type", "radiology")->latest()->paginate(10);
    $pathology = MedicalHistory::where("pet_id", $id)->where("type", "pathology")->latest()->paginate(10);
    $transferHistory = PetTransferLog::with('from_customer','to_customer', 'pet')->where('pet_id', $id )->get()->reverse();

    return view('admin-views.pet-medical-history.history', compact('pet', 'vaccineData', 'alergy', 'parasite','examination','surgery', 'prescription','lab_test','radiology','pathology', 'transferHistory'));
}
public function edit($id) {
    $history = MedicalHistory::find($id);

    // images
    if ($history->images != '' && $history->images != null) {
        
        $res = "";
        $images = explode('>|<', $history->images);
        foreach ($images as $image) {
            $res .= asset('storage/app/public/MedicalHistory') . '/' . $image . ">|<";
        }
        $history["images"] = $res;
    }
    

    
    // videos

    if ($history->video != '' && $history->video != null) {
        $vid = "";
        $videos = explode('>|<', $history->video);
        foreach ($videos as $video) {
            $vid .= asset('storage/app/public/MedicalHistory') . '/' . $video . ">|<";
        }
        
        $history["video"] = $vid;
    }

    // Documents
    if ($history->document != '' && $history->document != null) {
        $doc = "";
        $documents = explode('>|<', $history->document);
        foreach ($documents as $document) {
            $doc .= asset('storage/app/public/MedicalHistory') . '/' . $document . ">|<";
        }
        
        $history["document"] = $doc;
    }


    return response()->json([
        'status'=>200,
        'data' => $history,
    ]);
}

public function transferHistory($id){
    $transferHistories = PetTransferLog::with('from_customer','to_customer', 'pet')->where('pet_id', $id )->get();
    return view('admin-views.pet-medical-history.history', compact('transferHistories'));
}


public function store(Request $request)
{
    $validator = Validator::make($request->all(), [
        'type' => 'required',
        'date' => 'required',
        'pet_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json(['errors' => Helpers::error_processor($validator)], 500);
    }

    if($request->get("id") != null){
        $pet = MedicalHistory::find($request->id);
        $msg = 'History updated successfully!';
    }else{
        $pet = new MedicalHistory();
        $msg = 'History added successfully!';
    }

    $pet->title =$request->title;
    $pet->tempurature =$request->tempurature;
    $pet->weight =$request->weight;
    $pet->symptoms = implode('>|<', $request->input('symptoms', []));
    $pet->diagnosis = implode('>|<', $request->input('diagnosis', [])); 
    $pet->doctor =$request->doctor;
    $pet->place =$request->place;
    $pet->result =$request->result;

    $drugArray = $request->input('drug', []);
    $doseArray = $request->input('dose', []);

    $combinedArray = [];

    foreach ($drugArray as $key => $drug) {
        $combinedArray[] = $drug . '|>|' . $doseArray[$key];
    }

    $pet->drug = implode('<|||>', $combinedArray);



    $testArray = $request->input('test', []);
    $labTestResultArray = $request->input('lab_test_result', []);
    $labTestNormalArray = $request->input('lab_test_normal', []);

    $combinedTestArray = [];

    foreach ($testArray as $key => $test) {
        $combinedTestArray[] = $test . '|>|' . $labTestResultArray[$key] . '|<|' . $labTestNormalArray[$key];
    }

    $pet->test =implode('<|||>', $combinedTestArray);
    $pet->type = $request->type;
    $pet->date = $request->date;
    $pet->pet_id = $request->pet_id;


    if ($request->get("next_due_in") != null) {
        $pet->next_due_in = $request->next_due_in;
        $pet->period = $request->period;
        $pet->appointment_date = $request->appointment_date;
    
        if ($request->type == 'vaccine' || $request->type == 'parasite') {
            if ($request->date == $request->appointment_date || $request->date > $request->appointment_date) {
                Toastr::error('The next appointment date must be later than the previous appointment date.');
                return back();
            }
        }   
    } else {
        $pet->appointment_date = null;
    }
    

    if($request->get("notes") != null){
        $pet->notes = $request->notes;
    }

    // images

    $imageUrls = "";
    if($request->file("images") != null){
        foreach ($request->file("images") as $img) {
            $imageUrls .= ImageManager::upload('MedicalHistory/', $img->extension(), $img) . ">|<";
        }
        $imageUrls = substr($imageUrls , 0,strlen($imageUrls)-2);
        $pet->images = $imageUrls;
    }


    // videos
    $videoUrls = "";
    if($request->file("video") != null){
        foreach ($request->file("video") as $vid) {
            $videoUrls .= ImageManager::upload('MedicalHistory/', $vid->extension(), $vid) . ">|<";
        }
        $videoUrls = substr($videoUrls , 0,strlen($videoUrls)-2);
        $pet->video = $videoUrls;
    }


    // documents
    $documentUrls = "";
    if($request->file("document") != null){
        foreach ($request->file("document") as $doc) {
            $documentUrls .= ImageManager::upload('MedicalHistory/', $doc->extension(), $doc) . ">|<";
        }
        $documentUrls = substr($documentUrls , 0,strlen($documentUrls)-2);
        $pet->document = $documentUrls;
    }

    $pet->save();
    Toastr::success($msg);
    return back();
    
    

}
    public function delete(Request $request)
    {
        $history = MedicalHistory::find($request->id);
        MedicalHistory::where('id', $request->id)->delete();
        Toastr::success('History deleted successfully');
        return response()->json(200);
    }
    public function addMicrochipId(Request $request,$id){
        $validator = Validator::make($request->all(), [
            'microchip_id' => 'required',
        ]);
        $pet = PetApproval::find($request->id);
        $pet->microchip_id =$request->microchip_id;
        $pet->save();

        Toastr::success('Microchip id updated successfully!');
        return back();
    }
    // public function transferPet(Request $request){
    //     $validator = Validator::make($request->all(), [
    //         'customerid' => 'required',
    //     ]);
    //     $pet = PetApproval::find($request->id);
    //     $pet->customerid =$request->customerid;
    //     $pet->save();


    //     Toastr::success('Pet transfered successfully!');
    //     return back();
    // }

    public function transferPet(Request $request){
        $validator = Validator::make($request->all(), [
            'toCustomerid' => 'required',
        ]);
        $pet = PetApproval::find($request->PetId);
        if ($pet) {
            $pet->customerid = $request->toCustomerid;
            $pet->save();

            $petTransferLog = new PetTransferLog();
            $petTransferLog->from_customer_id = $request->fromCustomerId;
            $petTransferLog->to_customer_id = $request->toCustomerid;
            $petTransferLog->pet_id = $request->PetId;
            $petTransferLog->save();



            Toastr::success('Pet transferred successfully!');
        } else {
            Toastr::error('Pet not found');
        }
        return back();
    }
    

}
?>